/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.CachedContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;

public class FileContentLoader
extends CachedContentLoader {
    private final Path path;

    FileContentLoader(URI uri, URIContentLoader ... fallbackContentLoaders) {
        super(uri, fallbackContentLoaders);
        this.path = Path.of(FileContentLoader.getPath(uri), new String[0]);
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.FILE;
    }

    @Override
    protected Optional<Path> internalGetPath() {
        return Files.exists(this.path, new LinkOption[0]) ? Optional.of(this.path) : Optional.empty();
    }

    @Override
    protected byte[] loadURI(URI uri) {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }

    static String getPath(URI uri) {
        return uri.getPath();
    }
}

