/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionRef;
import java.util.Collection;
import java.util.Map;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.process.workitems.WorkParametersFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.MappingSetter;
import org.kie.kogito.serverless.workflow.parser.handlers.MappingUtils;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionParametersFactorySupplier;
import org.kie.kogito.serverless.workflow.suppliers.ObjectResolverSupplier;

public abstract class WorkItemBuilder {
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addFunctionArgs(Workflow workflow, WorkItemNodeFactory<T> node, FunctionRef functionRef) {
        JsonNode functionArgs = functionRef.getArguments();
        if (functionArgs != null) {
            this.processArgs(workflow, node, functionArgs, "Parameter");
        }
        return node;
    }

    protected void validateArgs(FunctionRef ref) {
        this.validateArgs(ref.getArguments());
    }

    protected void validateArgs(JsonNode args) {
    }

    protected WorkItemNodeFactory<?> buildWorkItem(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, ParserContext parserContext, String inputVar, String outputVar) {
        return MappingUtils.addMapping(embeddedSubProcess.workItemNode(parserContext.newId()), inputVar, outputVar);
    }

    protected final void processArgs(final Workflow workflow, final WorkItemNodeFactory<?> workItemFactory, JsonNode functionArgs, final String paramName) {
        MappingUtils.processArgs(workflow, functionArgs, new MappingSetter(){

            @Override
            public void accept(String key, Object value) {
                boolean isExpr = WorkItemBuilder.isExpression(workflow, value);
                ((WorkItemNodeFactory)workItemFactory.workParameter(key, isExpr ? new ObjectResolverSupplier(workflow.getExpressionLang(), value, paramName) : value)).workParameterDefinition(key, WorkItemBuilder.getDataType(value, isExpr));
            }

            @Override
            public void accept(Object value) {
                boolean isExpr = WorkItemBuilder.isExpression(workflow, value);
                if (isExpr) {
                    workItemFactory.workParameterFactory((WorkParametersFactory)new ExpressionParametersFactorySupplier(workflow.getExpressionLang(), value, paramName));
                } else {
                    workItemFactory.workParameter("ContentData", value);
                }
                workItemFactory.workParameterDefinition("ContentData", WorkItemBuilder.getDataType(value, isExpr));
            }
        });
    }

    private static boolean isExpression(Workflow workflow, Object value) {
        return value instanceof CharSequence && ExpressionHandlerFactory.get((String)workflow.getExpressionLang(), (String)value.toString()).isValid() || value instanceof JsonNode;
    }

    private static DataType getDataType(Object object, boolean isExpr) {
        if (object instanceof ObjectNode) {
            return DataTypeResolver.fromClass(Map.class);
        }
        if (object instanceof ArrayNode) {
            return DataTypeResolver.fromClass(Collection.class);
        }
        return DataTypeResolver.fromObject((Object)object, (boolean)isExpr);
    }
}

