/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.ResourceCacheFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedContentLoader
implements URIContentLoader {
    private static final Logger logger = LoggerFactory.getLogger(CachedContentLoader.class);
    protected final String uri;
    private URIContentLoader[] fallbackContentLoaders;

    protected CachedContentLoader(String uri, URIContentLoader ... fallbackContentLoaders) {
        this.uri = uri;
        this.fallbackContentLoaders = fallbackContentLoaders;
    }

    protected Optional<Path> internalGetPath() {
        return Optional.empty();
    }

    @Override
    public Optional<Path> getPath() {
        return this.internalGetPath().or(() -> {
            for (URIContentLoader contentLoader : this.fallbackContentLoaders) {
                Optional<Path> alternativePath = contentLoader.getPath();
                if (!alternativePath.isPresent()) continue;
                return alternativePath;
            }
            return Optional.empty();
        });
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new NoCopyByteArrayInputStream(ResourceCacheFactory.getCache().get(this.uri, this::loadURI));
        }
        catch (RuntimeException ex) {
            for (URIContentLoader contentLoader : this.fallbackContentLoaders) {
                try {
                    InputStream stream = contentLoader.getInputStream();
                    logger.warn("URI {} was retrieved using a fallback mechanism {} rather than original {}", new Object[]{this.uri, contentLoader.type(), this.type()});
                    return stream;
                }
                catch (RuntimeException supressed) {
                    ex.addSuppressed(supressed);
                }
            }
            throw ex;
        }
    }

    protected static String trimScheme(String uri, String scheme) {
        String str = uri;
        if (str.toLowerCase().startsWith(scheme)) {
            str = str.substring(scheme.length());
        }
        return str;
    }

    protected abstract byte[] loadURI();

    private static class NoCopyByteArrayInputStream
    extends ByteArrayInputStream {
        public NoCopyByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        @Override
        public synchronized byte[] readAllBytes() {
            if (this.pos == 0) {
                this.pos = this.count;
                return this.buf;
            }
            return super.readAllBytes();
        }
    }
}

