/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.io.CachedContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentLoader
extends CachedContentLoader {
    private final Path path;
    private static final Logger logger = LoggerFactory.getLogger(FileContentLoader.class);

    FileContentLoader(String uri, URIContentLoader ... fallbackContentLoaders) {
        super(uri, fallbackContentLoaders);
        this.path = FileContentLoader.obtainPath(uri);
    }

    @Override
    public URIContentLoaderType type() {
        return URIContentLoaderType.FILE;
    }

    private static Path obtainPath(String uri) {
        if (uri.startsWith(URIContentLoaderType.FILE.scheme())) {
            try {
                return Path.of(URI.create(uri));
            }
            catch (Exception ex) {
                logger.info("URI {} is not valid one according to Java, trying alternative approach", (Object)uri, (Object)ex);
            }
        }
        return Path.of(FileContentLoader.uriToPath(uri), new String[0]);
    }

    @Override
    protected Optional<Path> internalGetPath() {
        return Files.exists(this.path, new LinkOption[0]) ? Optional.of(this.path) : Optional.empty();
    }

    @Override
    protected byte[] loadURI() {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException io) {
            throw new UncheckedIOException(io);
        }
    }

    static String uriToPath(String uri) {
        return FileContentLoader.trimScheme(uri, URIContentLoaderType.FILE.scheme());
    }
}

