/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.io.File;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.serverless.workflow.io.ClassPathContentLoader;
import org.kie.kogito.serverless.workflow.io.FileContentLoader;
import org.kie.kogito.serverless.workflow.io.HttpContentLoader;

public enum URIContentLoaderType {
    CLASSPATH(ClassPathContentLoader::uriToPath, new char[0]),
    FILE(FileContentLoader::uriToPath, File.separatorChar),
    HTTP(HttpContentLoader::uriToPath, new char[0]),
    HTTPS(HttpContentLoader::uriToPath, new char[0]);

    private final char[] additionalSeparators;
    private final Function<String, String> getPathFunction;
    private final String scheme = this.name().toLowerCase() + ":";

    private URIContentLoaderType(Function<String, String> getPathFunction, char ... additionalSeparators) {
        this.getPathFunction = getPathFunction;
        this.additionalSeparators = additionalSeparators;
    }

    public static Optional<String> scheme(String uri) {
        int indexOf = uri.indexOf(":");
        return indexOf == -1 ? Optional.empty() : Optional.of(uri.substring(0, indexOf).toLowerCase());
    }

    public static URIContentLoaderType from(String uri) {
        return URIContentLoaderType.scheme(uri).map(scheme -> {
            switch (scheme) {
                default: {
                    return FILE;
                }
                case "classpath": {
                    return CLASSPATH;
                }
                case "http": {
                    return HTTP;
                }
                case "https": 
            }
            return HTTPS;
        }).orElse(FILE);
    }

    public boolean isAbsolutePath(String path) {
        if (!path.isBlank()) {
            char firstChar = path.trim().charAt(0);
            boolean result = firstChar == '/';
            for (int i = 0; !result && i < this.additionalSeparators.length; ++i) {
                result = firstChar == this.additionalSeparators[i];
            }
            return result;
        }
        return false;
    }

    public String concat(String basePath, String additionalPath) {
        if (this.isAbsolutePath(additionalPath)) {
            return this.keepSchemaIfPresent(basePath, additionalPath);
        }
        int indexOf = this.lastIndexOf(basePath);
        if (indexOf != -1) {
            return this.keepSchemaIfPresent(basePath, basePath.substring(0, indexOf + 1) + additionalPath);
        }
        return this.keepSchemaIfPresent(basePath, additionalPath);
    }

    private String keepSchemaIfPresent(String basePath, String resultPath) {
        return basePath.startsWith(this.scheme) && !resultPath.startsWith(this.scheme) ? this.scheme + resultPath : resultPath;
    }

    public String lastPart(String path) {
        int indexOf = this.lastIndexOf(path);
        return indexOf != -1 ? path.substring(indexOf + 1) : path;
    }

    public String scheme() {
        return this.scheme;
    }

    public String uriToPath(String uri) {
        return this.getPathFunction.apply(uri);
    }

    private int lastIndexOf(String path) {
        int indexOf = path.lastIndexOf(47);
        int i = 0;
        while (indexOf == -1 && i < this.additionalSeparators.length) {
            indexOf = path.lastIndexOf(this.additionalSeparators[i++]);
        }
        return indexOf;
    }
}

