/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.timeouts.WorkflowExecTimeout;
import io.serverlessworkflow.api.workflow.Constants;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.validation.impl.ProcessValidationErrorImpl;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.kie.api.definition.process.Process;
import org.kie.kogito.codegen.api.GeneratedInfo;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.validation.ValidationException;
import org.kie.kogito.serverless.workflow.extensions.OutputSchema;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactoryProvider;
import org.kie.kogito.serverless.workflow.parser.DefaultNodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.JsonSchemaReader;
import org.kie.kogito.serverless.workflow.parser.NodeIdGenerator;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.handlers.validation.WorkflowValidator;
import org.kie.kogito.serverless.workflow.suppliers.JsonSchemaValidatorSupplier;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.kie.kogito.serverless.workflow.utils.WorkflowFormat;

public class ServerlessWorkflowParser {
    public static final String NODE_START_NAME = "Start";
    public static final String NODE_END_NAME = "End";
    public static final String DEFAULT_PACKAGE = "org.kie.kogito.serverless";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    private NodeIdGenerator idGenerator = DefaultNodeIdGenerator.get();
    private Workflow workflow;
    private GeneratedInfo<KogitoWorkflowProcess> processInfo;
    private KogitoBuildContext context;

    public static ServerlessWorkflowParser of(Reader workflowFile, WorkflowFormat workflowFormat, KogitoBuildContext context) throws IOException {
        return ServerlessWorkflowParser.of(ServerlessWorkflowUtils.getWorkflow(workflowFile, workflowFormat), context);
    }

    @Deprecated
    public static ServerlessWorkflowParser of(Reader workflowFile, String workflowFormat, KogitoBuildContext context) throws IOException {
        return ServerlessWorkflowParser.of(ServerlessWorkflowUtils.getWorkflow(workflowFile, workflowFormat), context);
    }

    public static ServerlessWorkflowParser of(Workflow workflow, KogitoBuildContext context) {
        return new ServerlessWorkflowParser(workflow, context);
    }

    public ServerlessWorkflowParser withIdGenerator(NodeIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public ServerlessWorkflowParser withBaseURI(Path baseURI) {
        return this.withBaseURI(baseURI.toUri());
    }

    public ServerlessWorkflowParser withBaseURI(URI baseURI) {
        return this.withBaseURI(baseURI.toString());
    }

    public ServerlessWorkflowParser withBaseURI(URL baseURI) {
        return this.withBaseURI(baseURI.toString());
    }

    public ServerlessWorkflowParser withBaseURI(String baseURI) {
        ServerlessWorkflowUtils.withBaseURI(this.workflow, baseURI);
        return this;
    }

    private ServerlessWorkflowParser(Workflow workflow, KogitoBuildContext context) {
        this.workflow = workflow;
        this.context = context;
    }

    private GeneratedInfo<KogitoWorkflowProcess> parseProcess() {
        List annotations;
        String description;
        List tags;
        WorkflowExecTimeout workflowTimeout;
        TimeoutsDefinition timeouts;
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)this.workflow.getId(), (!this.workflow.isKeepActive() ? 1 : 0) != 0).name(this.workflow.getName() == null ? this.workflow.getId() : this.workflow.getName()).version(this.workflow.getVersion() == null ? DEFAULT_VERSION : this.workflow.getVersion()).packageName(this.workflow.getMetadata() != null ? this.workflow.getMetadata().getOrDefault("package", DEFAULT_PACKAGE) : DEFAULT_PACKAGE).visibility("Public").expressionLanguage(this.workflow.getExpressionLang()).metaData("Variable", (Object)DEFAULT_WORKFLOW_VAR).variable(DEFAULT_WORKFLOW_VAR, (DataType)new ObjectDataType(JsonNode.class), (Object)ObjectMapperFactory.listenerAware().createObjectNode()).type("SW");
        ParserContext parserContext = new ParserContext(this.idGenerator, factory, this.context, WorkflowOperationIdFactoryProvider.getFactory(this.context.getApplicationProperty("kogito.sw.operationIdStrategy")));
        WorkflowValidator.validateStart(this.workflow, parserContext);
        this.modelValidator(parserContext, Optional.ofNullable(this.workflow.getDataInputSchema())).ifPresent(arg_0 -> ((RuleFlowProcessFactory)factory).inputValidator(arg_0));
        this.modelValidator(parserContext, ServerlessWorkflowUtils.getExtension(this.workflow, OutputSchema.class).map(OutputSchema::getOutputSchema)).ifPresent(arg_0 -> ((RuleFlowProcessFactory)factory).outputValidator(arg_0));
        this.loadConstants(factory, parserContext);
        Collection handlers = this.workflow.getStates().stream().map(state -> StateHandlerFactory.getStateHandler(state, this.workflow, parserContext)).filter(Optional::isPresent).map(Optional::get).filter(state -> !state.usedForCompensation()).collect(Collectors.toList());
        handlers.forEach(StateHandler::handleStart);
        handlers.forEach(StateHandler::handleEnd);
        handlers.forEach(StateHandler::handleState);
        handlers.forEach(StateHandler::handleTransitions);
        handlers.forEach(StateHandler::handleConnections);
        if (parserContext.isCompensation()) {
            factory.metaData("Compensation", (Object)true);
            factory.metaData("compensateIfAborted", (Object)true);
            factory.addCompensationContext(this.workflow.getId());
        }
        if ((timeouts = this.workflow.getTimeouts()) != null && (workflowTimeout = timeouts.getWorkflowExecTimeout()) != null) {
            factory.metaData("processDuration", (Object)workflowTimeout.getDuration());
        }
        if ((tags = this.workflow.getAnnotations()) != null && !tags.isEmpty()) {
            factory.metaData("Tags", (Object)tags);
        }
        if (!ConversionUtils.isEmpty((String)(description = this.workflow.getDescription()))) {
            factory.metaData("Description", (Object)description);
        }
        if (!(annotations = this.workflow.getAnnotations()).isEmpty()) {
            factory.metaData("annotations", (Object)annotations);
        }
        factory.link();
        List errors = RuleFlowProcessValidator.getInstance().validateProcess(factory.getProcess(), new ArrayList());
        parserContext.validationErrors().forEach(m -> errors.add(new ProcessValidationErrorImpl((Process)factory.getProcess(), m)));
        if (!errors.isEmpty()) {
            throw new ValidationException(factory.getProcess().getId(), (Collection)errors);
        }
        return new GeneratedInfo((Object)factory.getProcess(), parserContext.generatedFiles());
    }

    private Optional<WorkflowModelValidator> modelValidator(ParserContext parserContext, Optional<DataInputSchema> schema) {
        return schema.map(s -> new JsonSchemaValidatorSupplier(JsonSchemaReader.read(ServerlessWorkflowUtils.getBaseURI(this.workflow).map(u -> URIContentLoaderFactory.compoundURI(u, s.getSchema())).orElseGet(() -> s.getSchema()), URIContentLoaderFactory.readBytes(s.getSchema(), this.workflow, parserContext)), s.isFailOnValidationErrors()));
    }

    public GeneratedInfo<KogitoWorkflowProcess> getProcessInfo() {
        if (this.processInfo == null) {
            this.processInfo = this.parseProcess();
        }
        return this.processInfo;
    }

    private void loadConstants(RuleFlowProcessFactory factory, ParserContext parserContext) {
        Constants constants = this.workflow.getConstants();
        if (constants != null) {
            if (constants.getRefValue() != null) {
                try {
                    constants.setConstantsDef((JsonNode)ObjectMapperFactory.get().readValue(URIContentLoaderFactory.readBytes(constants.getRefValue(), this.workflow, parserContext), JsonNode.class));
                }
                catch (IOException e) {
                    parserContext.addValidationError("Invalid file " + constants.getRefValue() + e);
                    return;
                }
            }
            factory.metaData("Constants", (Object)constants.getConstantsDef());
        }
    }
}

