/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.ActionResource;

public class ActionResourceFactory {
    private static final Map<FunctionDefinition.Type, BiFunction<String, Optional<ParserContext>, ActionResource>> map = Map.of(FunctionDefinition.Type.REST, ActionResourceFactory::justOperation, FunctionDefinition.Type.ASYNCAPI, ActionResourceFactory::justOperation, FunctionDefinition.Type.RPC, ActionResourceFactory::withService);

    private static ActionResource justOperation(String operationStr, Optional<ParserContext> context) {
        String[] tokens = ActionResourceFactory.getTokens(operationStr, 2, context);
        return new ActionResource(tokens[0], tokens[1], null);
    }

    private static ActionResource withService(String operationStr, Optional<ParserContext> context) {
        String[] tokens = ActionResourceFactory.getTokens(operationStr, 3, context);
        return new ActionResource(tokens[0], tokens[2], tokens[1]);
    }

    private static String[] getTokens(String operationStr, int expectedTokens, Optional<ParserContext> context) {
        String[] tokens = operationStr.split("#");
        if (tokens.length != expectedTokens) {
            String msg = String.format("%s should have just %d %s", operationStr, expectedTokens - 1, "#");
            context.ifPresentOrElse(c -> c.addValidationError(msg), () -> {
                throw new IllegalArgumentException(msg);
            });
        }
        return tokens;
    }

    public static ActionResource getActionResource(FunctionDefinition function, Optional<ParserContext> context) {
        String operation;
        BiFunction<String, Optional<ParserContext>, ActionResource> factory = map.get(function.getType());
        if (factory == null) {
            String msg = function.getType() + " does not support action resources";
            context.ifPresentOrElse(c -> c.addValidationError(msg), () -> {
                throw new UnsupportedOperationException(msg);
            });
        }
        if ((operation = function.getOperation()) == null) {
            String msg = "operation string must not be null for function " + function.getName();
            context.ifPresentOrElse(c -> c.addValidationError(msg), () -> {
                throw new IllegalArgumentException(msg);
            });
        }
        return factory.apply(operation, context);
    }

    private ActionResourceFactory() {
    }
}

