/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.error.ErrorDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.filters.EventDataFilter;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import io.serverlessworkflow.api.workflow.Errors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.jbpm.compiler.canonical.descriptors.ExpressionReturnValueSupplier;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.SupportsAction;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.VariableInfo;
import org.kie.kogito.serverless.workflow.parser.handlers.MakeNodeResult;
import org.kie.kogito.serverless.workflow.parser.handlers.NodeFactoryUtils;
import org.kie.kogito.serverless.workflow.suppliers.CollectorActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.CompensationActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ErrorExpressionActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ExpressionActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.MergeActionSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ProduceEventActionSupplier;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateHandler<S extends State> {
    private static Logger logger = LoggerFactory.getLogger(StateHandler.class);
    protected static final String XORSPLITDEFAULT = "Default";
    protected final S state;
    protected final Workflow workflow;
    protected final ParserContext parserContext;
    private NodeFactory<?, ?> startNodeFactory;
    private NodeFactory<?, ?> endNodeFactory;
    private NodeFactory<?, ?> node;
    private NodeFactory<?, ?> outgoingNode;
    protected final boolean isStartState;
    private JoinFactory<?> join;
    private Collection<WorkflowElementIdentifier> incomingConnections = new ArrayList<WorkflowElementIdentifier>();

    protected StateHandler(S state, Workflow workflow, ParserContext parserContext) {
        this.workflow = workflow;
        this.state = state;
        this.parserContext = parserContext;
        this.isStartState = state.getName().equals(workflow.getStart().getStateName());
    }

    public boolean usedForCompensation() {
        return false;
    }

    public void handleStart() {
        if (this.isStartState) {
            WorkflowElementIdentifier id = this.parserContext.newId();
            this.startNodeFactory = ((StartNodeFactory)this.parserContext.factory().startNode(id).name("Start")).metaData("state", (Object)this.state.getName());
            this.startNodeFactory.done();
        }
    }

    public void handleEnd() {
        End endState = this.state.getEnd();
        if (endState != null) {
            this.endNodeFactory = this.endNodeFactory((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), endState).name("End").metaData("state", (Object)this.state.getName());
            this.endNodeFactory.done();
        }
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, ProduceEvent event) {
        return this.sendEventNode(actionNode, this.eventDefinition(event.getEventRef()), event.getData(), "workflowdata");
    }

    protected final <T extends NodeFactory<?, ?>> NodeFactory<?, ?> sendEventNode(T actionNode, EventDefinition eventDefinition, String data, String defaultWorkflowVar) {
        return NodeFactoryUtils.sendEventNode(((SupportsAction)actionNode).action((Action)new ProduceEventActionSupplier(this.workflow, eventDefinition.getType(), defaultWorkflowVar, data)), eventDefinition, defaultWorkflowVar);
    }

    private void handleCompensation(RuleFlowNodeContainerFactory<?, ?> factory) {
        StateHandler<?> compensation = this.parserContext.getStateHandler(this.state.getCompensatedBy());
        if (compensation == null) {
            this.parserContext.addValidationError("State " + this.getState().getName() + " refers to a compensation " + this.state.getCompensatedBy() + " which cannot be found");
        }
        this.parserContext.setCompensation();
        WorkflowElementIdentifier eventCompensationId = this.parserContext.newId();
        WorkflowElementIdentifier subprocessCompensationId = this.parserContext.newId();
        WorkflowElementIdentifier startCompensationId = this.parserContext.newId();
        String uniqueId = this.outgoingNode.getNode().getUniqueId();
        factory.boundaryEventNode(eventCompensationId).addCompensationHandler(uniqueId).attachedTo(uniqueId).eventType("Compensation").metaData("EventType", (Object)"compensation");
        CompositeContextNodeFactory embeddedSubProcess = (CompositeContextNodeFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)factory.compositeContextNode(subprocessCompensationId).autoComplete(true)).metaData("isForCompensation", (Object)true)).startNode(startCompensationId).interrupting(true).done();
        factory.association(eventCompensationId, subprocessCompensationId, null);
        WorkflowElementIdentifier lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
        embeddedSubProcess.connection(startCompensationId, lastNodeId);
        compensation = this.parserContext.getStateHandler(compensation);
        while (compensation != null) {
            if (!compensation.usedForCompensation()) {
                this.parserContext.addValidationError("Compensation state can only have transition to other compensation state. State " + compensation.getState().getName() + " is not used for compensation");
            }
            lastNodeId = this.handleCompensation((RuleFlowNodeContainerFactory<?, ?>)embeddedSubProcess, compensation);
            compensation = this.parserContext.getStateHandler(compensation);
        }
        WorkflowElementIdentifier endCompensationId = this.parserContext.newId();
        ((CompositeContextNodeFactory)embeddedSubProcess.endNode(endCompensationId).terminate(false).done()).connection(lastNodeId, endCompensationId);
    }

    private WorkflowElementIdentifier handleCompensation(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, StateHandler<?> compensation) {
        if (compensation.getState().getCompensatedBy() != null) {
            this.parserContext.addValidationError("Serverless workflow specification forbids nested compensations, hence state " + compensation.getState().getName() + " is not valid");
        }
        compensation.handleState(embeddedSubProcess);
        Transition transition = compensation.getState().getTransition();
        compensation.handleTransitions(embeddedSubProcess, transition, compensation.getNode());
        compensation.handleConnections(embeddedSubProcess);
        return compensation.getOutgoingNode().getNode().getId();
    }

    public void handleState() {
        this.handleState((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleState(RuleFlowNodeContainerFactory<?, ?> factory) {
        MakeNodeResult result = this.makeNode(factory);
        this.node = result.getIncomingNode().metaData("state", (Object)this.state.getName()).metaData("MetricName", (Object)this.state.getName());
        this.outgoingNode = result.getOutgoingNode().metaData("state", (Object)this.state.getName());
        if (this.state.getCompensatedBy() != null) {
            this.handleCompensation(factory);
        }
        this.node.done();
        this.outgoingNode.done();
        StateDataFilter stateFilter = this.state.getStateDataFilter();
        if (stateFilter != null) {
            String output;
            String input = stateFilter.getInput();
            if (input != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, input);
                factory.connection(actionNode.getNode().getId(), this.node.getNode().getId());
                this.node = actionNode.metaData("state", (Object)this.state.getName());
            }
            if ((output = stateFilter.getOutput()) != null) {
                ActionNodeFactory<?> actionNode = this.handleStateFilter(factory, output);
                factory.connection(this.outgoingNode.getNode().getId(), actionNode.getNode().getId());
                this.outgoingNode = ((ActionNodeFactory)actionNode.metaData("state", (Object)this.state.getName())).metaData("MetricName", (Object)this.state.getName());
            }
        }
        this.connectStart(factory);
        this.connectEnd(factory);
    }

    private ActionNodeFactory<?> handleStateFilter(RuleFlowNodeContainerFactory<?, ?> factory, String filter) {
        WorkflowElementIdentifier id = this.parserContext.newId();
        ActionNodeFactory result = factory.actionNode(id).action((Action)ExpressionActionSupplier.of(this.workflow, filter).build());
        result.done();
        return result;
    }

    protected void connectSource(NodeFactory<?, ?> sourceNode) {
        WorkflowElementIdentifier id = sourceNode.getNode().getId();
        if (sourceNode instanceof SplitFactory || !this.incomingConnections.contains(id)) {
            this.incomingConnections.add(id);
        }
    }

    public void handleConnections() {
        this.handleConnections((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory());
    }

    protected void handleConnections(RuleFlowNodeContainerFactory<?, ?> factory) {
        NodeFactory<?, ?> incoming = this.getIncomingNode(factory);
        for (WorkflowElementIdentifier sourceId : this.incomingConnections) {
            factory.connection(sourceId, incoming.getNode().getId());
        }
    }

    private boolean hasCode(ErrorDefinition errorDef) {
        if (errorDef.getCode() == null) {
            logger.error("Kogito requires code error to be set. Ignoring {}", (Object)errorDef.getName());
            return false;
        }
        return true;
    }

    protected final Collection<ErrorDefinition> getErrorDefinitions(Error error) {
        Errors errors = this.workflow.getErrors();
        if (errors == null) {
            this.parserContext.addValidationError("workflow should contain errors property");
            return Collections.emptyList();
        }
        List errorDefs = errors.getErrorDefs();
        if (errorDefs == null) {
            this.parserContext.addValidationError("workflow errors property must contain errorDefs property");
            return Collections.emptyList();
        }
        if (error.getErrorRef() != null) {
            return this.getErrorsDefinitions(errorDefs, Arrays.asList(error.getErrorRef()));
        }
        if (error.getErrorRefs() != null) {
            return this.getErrorsDefinitions(errorDefs, error.getErrorRefs());
        }
        this.parserContext.addValidationError("state errors should contain either errorRef or errorRefs property");
        return Collections.emptyList();
    }

    private Collection<ErrorDefinition> getErrorsDefinitions(List<ErrorDefinition> errorDefs, List<String> errorRefs) {
        ArrayList<ErrorDefinition> result = new ArrayList<ErrorDefinition>();
        for (String errorRef : errorRefs) {
            errorDefs.stream().filter(errorDef -> errorDef.getName().equals(errorRef) && this.hasCode((ErrorDefinition)errorDef)).findAny().ifPresentOrElse(result::add, () -> this.parserContext.addValidationError("Cannot find any error definition for errorRef" + errorRef));
        }
        return result;
    }

    protected final void handleErrors(RuleFlowNodeContainerFactory<?, ?> factory, RuleFlowNodeContainerFactory<?, ?> targetNode) {
        for (Error error : this.state.getOnErrors()) {
            this.getErrorDefinitions(error).forEach(errorDef -> {
                String errorPrefix = "Error-" + targetNode.getNode().getUniqueId() + "-";
                WorkflowElementIdentifier id = this.parserContext.newId();
                BoundaryEventNodeFactory boundaryNode = (BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)factory.boundaryEventNode(id).attachedTo(targetNode.getNode().getId().toExternalFormat()).metaData("EventType", (Object)"error")).metaData("HasErrorEvent", (Object)true)).metaData("ErrorEvent", (Object)errorDef.getCode())).eventType(errorPrefix + errorDef.getCode()).name("Error-" + targetNode.getNode().getName() + "-" + errorDef.getCode());
                targetNode.exceptionHandler(errorDef.getCode(), errorDef.getCode());
                if (error.getEnd() != null) {
                    this.connect((NodeFactory<?, ?>)boundaryNode, this.endNodeFactory(factory, error.getEnd()));
                } else {
                    this.handleTransitions(factory, error.getTransition(), (NodeFactory<?, ?>)boundaryNode);
                }
            });
        }
    }

    public void handleTransitions() {
        this.handleTransitions((RuleFlowNodeContainerFactory<?, ?>)this.parserContext.factory(), this.state.getTransition(), this.outgoingNode);
    }

    protected void handleTransitions(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, NodeFactory<?, ?> sourceNode) {
        this.handleTransition(factory, transition, sourceNode, Optional.empty());
    }

    private void connectStart(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.startNodeFactory != null) {
            factory.connection(this.startNodeFactory.getNode().getId(), this.node.getNode().getId());
        }
    }

    private void connectEnd(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.endNodeFactory != null) {
            if (this.state.getEnd().isCompensate()) {
                this.endNodeFactory.done().connection(this.compensationEvent(factory, this.outgoingNode).getNode().getId(), this.endNodeFactory.getNode().getId());
            } else {
                factory.connection(this.outgoingNode.getNode().getId(), this.endNodeFactory.getNode().getId());
            }
        }
    }

    public final NodeFactory<?, ?> getNode() {
        return this.node;
    }

    public final NodeFactory<?, ?> getOutgoingNode() {
        return this.outgoingNode;
    }

    public S getState() {
        return this.state;
    }

    public NodeFactory<?, ?> getIncomingNode(RuleFlowNodeContainerFactory<?, ?> factory) {
        if (this.join != null) {
            return this.join;
        }
        if (this.incomingConnections.size() > 1) {
            WorkflowElementIdentifier id = this.parserContext.newId();
            this.join = (JoinFactory)factory.joinNode(id).type(5).name("Join-" + this.node.getNode().getName()).metaData("state", (Object)this.state.getName());
            this.join.done().connection(this.join.getNode().getId(), this.node.getNode().getId());
            return this.join;
        }
        return this.getNode();
    }

    protected abstract MakeNodeResult makeNode(RuleFlowNodeContainerFactory<?, ?> var1);

    protected final void handleTransition(RuleFlowNodeContainerFactory<?, ?> factory, Transition transition, NodeFactory<?, ?> sourceFactory, Optional<HandleTransitionCallBack> callback) {
        StateHandler<?> targetState = this.parserContext.getStateHandler(transition);
        if (targetState != null) {
            List produceEvents = transition.getProduceEvents();
            if (produceEvents.isEmpty()) {
                if (transition.isCompensate()) {
                    NodeFactory<?, ?> compensationNode = this.compensationEvent(factory, sourceFactory);
                    targetState.connectSource(compensationNode);
                    callback.ifPresent(c -> c.onIdTarget(compensationNode.getNode().getId()));
                } else {
                    targetState.connectSource(sourceFactory);
                    callback.ifPresent(c -> c.onStateTarget(targetState));
                }
            } else {
                WorkflowElementIdentifier id = this.parserContext.newId();
                ActionNodeFactory actionNode = (ActionNodeFactory)factory.actionNode(id).metaData("state", (Object)this.state.getName());
                NodeFactory<?, ?> startNode = this.handleProduceEvents(factory, actionNode, produceEvents);
                factory.connection(sourceFactory.getNode().getId(), startNode.getNode().getId());
                if (transition.isCompensate()) {
                    WorkflowElementIdentifier eventId = this.compensationEvent(factory, sourceFactory).getNode().getId();
                    callback.ifPresent(c -> c.onIdTarget(eventId));
                } else {
                    callback.ifPresent(c -> c.onIdTarget(startNode.getNode().getId()));
                }
                targetState.connectSource((NodeFactory<?, ?>)actionNode);
            }
        } else {
            callback.ifPresentOrElse(HandleTransitionCallBack::onEmptyTarget, () -> {
                if (transition != null) {
                    this.parserContext.addValidationError(String.format("There is no state for transition %s originated in %s", transition.getNextState(), this.state.getName()));
                }
            });
        }
    }

    private <T extends NodeFactory<?, ?>> NodeFactory<?, ?> handleProduceEvents(RuleFlowNodeContainerFactory<?, ?> factory, T endNode, List<ProduceEvent> produceEvents) {
        Object startNode = endNode;
        this.sendEventNode(endNode, produceEvents.get(0));
        if (produceEvents.size() > 1) {
            ListIterator<ProduceEvent> iter = produceEvents.listIterator(1);
            while (iter.hasNext()) {
                T currentNode = startNode;
                WorkflowElementIdentifier id = this.parserContext.newId();
                startNode = this.sendEventNode(factory.actionNode(id), iter.next());
                this.connect((NodeFactory<?, ?>)startNode, currentNode);
            }
        }
        return startNode;
    }

    protected final String getVarName() {
        return this.state.getName() + "_" + this.parserContext.newId().toSanitizeString();
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, FilterableNodeSupplier nodeSupplier) {
        return this.filterAndMergeNode(embeddedSubProcess, eventFilter, this.getVarName(), nodeSupplier);
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, EventDataFilter eventFilter, String varName, FilterableNodeSupplier nodeSupplier) {
        String dataExpr = null;
        String toExpr = null;
        boolean useData = true;
        if (eventFilter != null) {
            dataExpr = eventFilter.getData();
            toExpr = eventFilter.getToStateData();
            useData = eventFilter.isUseData();
        }
        return this.filterAndMergeNode(embeddedSubProcess, this.isStartState ? new VariableInfo("workflowdata", varName) : new VariableInfo(varName, varName), null, dataExpr, toExpr, useData, true, nodeSupplier);
    }

    protected boolean isTempVariable(String varName) {
        return !varName.equals("workflowdata");
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String actionVarName, String fromStateExpr, String resultExpr, String toStateExpr, boolean useData, boolean shouldMerge, FilterableNodeSupplier nodeSupplier) {
        return this.filterAndMergeNode(embeddedSubProcess, new VariableInfo(actionVarName, actionVarName), fromStateExpr, resultExpr, toStateExpr, useData, shouldMerge, nodeSupplier);
    }

    protected final MakeNodeResult filterAndMergeNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, VariableInfo variableInfo, String fromStateExpr, String resultExpr, String toStateExpr, boolean useData, boolean shouldMerge, FilterableNodeSupplier nodeSupplier) {
        NodeFactory<?, ?> currentNode;
        NodeFactory<?, ?> startNode;
        WorkflowElementIdentifier id;
        String actionVarName = variableInfo.getOutputVar();
        if (this.isTempVariable(actionVarName)) {
            embeddedSubProcess.variable(actionVarName, (DataType)new ObjectDataType(JsonNode.class.getCanonicalName()), Map.of("customTags", "internal"));
        }
        if (fromStateExpr != null) {
            id = this.parserContext.newId();
            startNode = embeddedSubProcess.actionNode(id).action((Action)ExpressionActionSupplier.of(this.workflow, fromStateExpr).withVarNames("workflowdata", actionVarName).build()).metaData("state", (Object)this.state.getName());
            currentNode = this.connect(startNode, nodeSupplier.apply(embeddedSubProcess, actionVarName, actionVarName).metaData("state", (Object)this.state.getName()));
        } else {
            startNode = currentNode = nodeSupplier.apply(embeddedSubProcess, "workflowdata", actionVarName);
        }
        if (useData && resultExpr != null) {
            currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(this.parserContext.newId()).action((Action)ExpressionActionSupplier.of(this.workflow, resultExpr).withVarNames(variableInfo.getInputVar(), actionVarName).build()));
        }
        if (useData) {
            if (toStateExpr != null) {
                id = this.parserContext.newId();
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(id).action((Action)new CollectorActionSupplier(this.workflow.getExpressionLang(), toStateExpr, "workflowdata", actionVarName)));
            } else if (shouldMerge) {
                id = this.parserContext.newId();
                currentNode = this.connect(currentNode, (NodeFactory<?, ?>)embeddedSubProcess.actionNode(id).action((Action)new MergeActionSupplier(actionVarName, "workflowdata")));
            }
        }
        currentNode.done();
        return new MakeNodeResult(startNode, currentNode);
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, NodeFactory<?, ?> nodeFactory) {
        currentNode.done().connection(currentNode.getNode().getId(), nodeFactory.getNode().getId());
        return nodeFactory;
    }

    protected final NodeFactory<?, ?> connect(NodeFactory<?, ?> currentNode, MakeNodeResult twoNodes) {
        this.connect(currentNode, twoNodes.getIncomingNode()).done();
        return twoNodes.getOutgoingNode();
    }

    protected final NodeFactory<?, ?> consumeEventNode(RuleFlowNodeContainerFactory<?, ?> factory, String eventRef, String inputVar, String outputVar) {
        EventDefinition eventDefinition = this.eventDefinition(eventRef);
        WorkflowElementIdentifier id = this.parserContext.newId();
        return NodeFactoryUtils.consumeMessageNode(factory.eventNode(id), eventDefinition, inputVar, outputVar);
    }

    protected final EventDefinition eventDefinition(String eventName) {
        return this.workflow.getEvents().getEventDefs().stream().filter(wt -> wt.getName().equals(eventName)).findFirst().orElseThrow(() -> new NoSuchElementException("No event for " + eventName));
    }

    protected final MakeNodeResult makeTimeoutNode(RuleFlowNodeContainerFactory<?, ?> factory, MakeNodeResult notTimerBranch) {
        String eventTimeout = TimeoutsConfigResolver.resolveEventTimeout(this.state, this.workflow);
        if (eventTimeout != null) {
            WorkflowElementIdentifier splitId = this.parserContext.newId();
            SplitFactory splitNode = NodeFactoryUtils.eventBasedSplitNode(factory.splitNode(splitId), 4);
            WorkflowElementIdentifier joinId = this.parserContext.newId();
            JoinFactory joinNode = NodeFactoryUtils.joinExclusiveNode((JoinFactory)factory.joinNode(joinId).metaData("UniqueId", (Object)joinId.toExternalFormat()));
            this.connect(this.connect((NodeFactory<?, ?>)splitNode, notTimerBranch), (NodeFactory<?, ?>)joinNode);
            this.createTimerNode(factory, splitNode, joinNode, eventTimeout);
            return new MakeNodeResult((NodeFactory<?, ?>)splitNode, (NodeFactory<?, ?>)joinNode);
        }
        return notTimerBranch;
    }

    protected final void createTimerNode(RuleFlowNodeContainerFactory<?, ?> factory, SplitFactory<?> splitNode, JoinFactory<?> joinNode, String eventTimeout) {
        WorkflowElementIdentifier id = this.parserContext.newId();
        TimerNodeFactory eventTimeoutTimerNode = NodeFactoryUtils.timerNode(factory.timerNode(id), eventTimeout);
        this.connect((NodeFactory<?, ?>)splitNode, (NodeFactory<?, ?>)eventTimeoutTimerNode);
        this.connect((NodeFactory<?, ?>)eventTimeoutTimerNode, (NodeFactory<?, ?>)joinNode);
    }

    protected final NodeFactory<?, ?> endNodeFactory(RuleFlowNodeContainerFactory<?, ?> factory, End end) {
        String errorMessage;
        Map metadata;
        ActionNodeFactory nodeFactory;
        WorkflowElementIdentifier id = this.parserContext.newId();
        ActionNodeFactory startNode = nodeFactory = factory.endNode(id);
        List produceEvents = end.getProduceEvents();
        if (produceEvents != null && !produceEvents.isEmpty()) {
            startNode = this.handleProduceEvents(factory, nodeFactory, produceEvents);
        }
        if ((metadata = this.state.getMetadata()) != null && (errorMessage = (String)metadata.get("errorMessage")) != null && !errorMessage.isBlank()) {
            ActionNodeFactory errorMessageNode = factory.actionNode(this.parserContext.newId()).action((Action)new ErrorExpressionActionSupplier(this.workflow.getExpressionLang(), errorMessage, "workflowdata"));
            this.connect((NodeFactory<?, ?>)errorMessageNode, (NodeFactory<?, ?>)startNode);
            startNode = errorMessageNode;
        }
        nodeFactory.terminate(end.isTerminate());
        return startNode;
    }

    private NodeFactory<?, ?> compensationEvent(RuleFlowNodeContainerFactory<?, ?> factory, NodeFactory<?, ?> sourceFactory) {
        WorkflowElementIdentifier eventId = this.parserContext.newId();
        ActionNodeFactory compensationNode = factory.actionNode(eventId).name(this.state.getName() + "-" + eventId.toExternalFormat()).action((Action)new CompensationActionSupplier("implicit:" + this.workflow.getId()));
        compensationNode.done().connection(sourceFactory.getNode().getId(), eventId);
        return compensationNode;
    }

    protected final <T extends RuleFlowNodeContainerFactory<T, ?>> SplitFactory<T> addCondition(SplitFactory<T> splitNode, NodeFactory<?, ?> targetNode, String condition, boolean isDefault) {
        return this.addCondition(splitNode, targetNode.getNode().getId(), condition, isDefault);
    }

    protected final <T extends RuleFlowNodeContainerFactory<T, ?>> SplitFactory<T> addCondition(SplitFactory<T> splitNode, WorkflowElementIdentifier targetId, String condition, boolean isDefault) {
        WorkflowElementIdentifier splitNodeId = StateHandler.concatId(splitNode.getNode().getId(), targetId);
        return (SplitFactory)((SplitFactory)splitNode.constraint(targetId, splitNodeId.toSanitizeString(), "DROOLS_DEFAULT", this.workflow.getExpressionLang(), (ReturnValueEvaluator)new ExpressionReturnValueSupplier(this.workflow.getExpressionLang(), ExpressionHandlerUtils.replaceExpr((Workflow)this.workflow, (String)condition), "workflowdata"), 0, isDefault)).metaData("Variable", (Object)"workflowdata");
    }

    protected static WorkflowElementIdentifier concatId(WorkflowElementIdentifier start, WorkflowElementIdentifier end) {
        return WorkflowElementIdentifierFactory.fromExternalFormat((String)(start.toSanitizeString() + "_" + end.toSanitizeString()));
    }

    public MakeNodeResult faultyNodeResult(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String message) {
        return new MakeNodeResult(this.faultyNode(embeddedSubProcess, message));
    }

    public NodeFactory<?, ?> faultyNode(RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, String message) {
        this.parserContext.addValidationError(message);
        return embeddedSubProcess.actionNode(this.parserContext.newId());
    }

    @FunctionalInterface
    protected static interface FilterableNodeSupplier {
        public NodeFactory<?, ?> apply(RuleFlowNodeContainerFactory<?, ?> var1, String var2, String var3);
    }

    protected static interface HandleTransitionCallBack {
        default public void onStateTarget(StateHandler<?> targetState) {
        }

        default public void onIdTarget(WorkflowElementIdentifier targetId) {
        }

        default public void onEmptyTarget() {
        }
    }
}

