/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers.validation;

import io.serverlessworkflow.api.Workflow;
import java.util.Map;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class WorkflowValidator {
    private WorkflowValidator() {
    }

    public static void validateStart(Workflow workflow, ParserContext context) {
        Map<String, Integer> functionDuplicates;
        if (workflow.getStart() == null || ConversionUtils.isEmpty((String)workflow.getStart().getStateName())) {
            context.addValidationError("Workflow does not define a starting state");
        }
        if (workflow.getFunctions() != null && !(functionDuplicates = ServerlessWorkflowUtils.findDuplicates(workflow.getFunctions().getFunctionDefs(), f -> f.getName())).isEmpty()) {
            StringBuilder sb = new StringBuilder("There are duplicated function definitions: ");
            functionDuplicates.forEach((k, v) -> sb.append(String.format("\nFunction %s appears %d times", k, v)));
            context.addValidationError(sb.toString());
        }
    }
}

