/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.github.javaparser.ast.expr.Expression;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.deserializers.ExtensionDeserializer;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.mapper.BaseObjectMapper;
import io.serverlessworkflow.api.mapper.JsonObjectMapper;
import io.serverlessworkflow.api.mapper.YamlObjectMapper;
import io.serverlessworkflow.api.serializers.ExtensionSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jbpm.compiler.canonical.ModelMetaData;
import org.jbpm.compiler.canonical.VariableDeclarations;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.serverless.workflow.extensions.FunctionNamespaces;
import org.kie.kogito.serverless.workflow.extensions.OutputSchema;
import org.kie.kogito.serverless.workflow.extensions.URIDefinitions;
import org.kie.kogito.serverless.workflow.models.JsonNodeModel;
import org.kie.kogito.serverless.workflow.suppliers.ConfigWorkItemSupplier;
import org.kie.kogito.serverless.workflow.utils.WorkflowFormat;

public class ServerlessWorkflowUtils {
    public static final String FAIL_ON_ERROR_PROPERTY = "kogito.codegen.process.failOnError";
    public static final String API_KEY_PREFIX = "api_key_prefix";
    public static final String API_KEY = "api_key";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String USER_PROP = "username";
    public static final String PASSWORD_PROP = "password";
    public static final String OPERATION_SEPARATOR = "#";
    public static final String DEFS_PREFIX = "#/$defs/";
    private static final String BASE_URI = "baseURI";
    @Deprecated
    public static final String DEFAULT_WORKFLOW_FORMAT = "json";
    @Deprecated
    public static final String ALTERNATE_WORKFLOW_FORMAT = "yml";
    public static final String APP_PROPERTIES_BASE = "kogito.sw.";
    public static final String APP_PROPERTIES_FUNCTIONS_BASE = "kogito.sw.functions.";
    private static final String REGEX_NO_EXT = "[.][^.]+$";
    private static final BaseObjectMapper yamlReaderMapper = ServerlessWorkflowUtils.deserializer((BaseObjectMapper)new YamlObjectMapper());
    private static final BaseObjectMapper jsonReaderMapper = ServerlessWorkflowUtils.deserializer((BaseObjectMapper)new JsonObjectMapper());
    private static final BaseObjectMapper yamlWriterMapper = ServerlessWorkflowUtils.serializer((BaseObjectMapper)new YamlObjectMapper());
    private static final BaseObjectMapper jsonWriterMapper = ServerlessWorkflowUtils.serializer((BaseObjectMapper)new JsonObjectMapper());

    private ServerlessWorkflowUtils() {
    }

    public static Workflow getWorkflow(Reader reader, WorkflowFormat workflowFormat) throws IOException {
        BaseObjectMapper objectMapper = workflowFormat == WorkflowFormat.YAML ? yamlReaderMapper : jsonReaderMapper;
        return (Workflow)objectMapper.readValue(reader, Workflow.class);
    }

    public static Workflow getWorkflow(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Workflow workflow = ServerlessWorkflowUtils.withBaseURI(ServerlessWorkflowUtils.getWorkflow((Reader)reader, WorkflowFormat.fromFileName(path.getFileName())), path.toString());
            return workflow;
        }
    }

    public static Workflow getWorkflow(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            Workflow workflow = ServerlessWorkflowUtils.withBaseURI(ServerlessWorkflowUtils.getWorkflow((Reader)reader, WorkflowFormat.fromFileName(url.getPath())), url.toString());
            return workflow;
        }
    }

    @Deprecated
    public static Workflow getWorkflow(Reader reader, String workflowFormat) throws IOException {
        return ServerlessWorkflowUtils.getWorkflow(reader, ALTERNATE_WORKFLOW_FORMAT.equals(workflowFormat) ? WorkflowFormat.YAML : WorkflowFormat.JSON);
    }

    public static void writeWorkflow(Workflow workflow, Writer writer, WorkflowFormat workflowFormat) throws IOException {
        BaseObjectMapper objectMapper = workflowFormat == WorkflowFormat.YAML ? yamlWriterMapper : jsonWriterMapper;
        objectMapper.writeValue(writer, (Object)workflow);
    }

    public static Optional<String> getBaseURI(Workflow workflow) {
        return Optional.ofNullable(ServerlessWorkflowUtils.getMetadata(workflow).get(BASE_URI));
    }

    public static Workflow withBaseURI(Workflow workflow, String baseURI) {
        ServerlessWorkflowUtils.getMetadata(workflow).put(BASE_URI, baseURI);
        return workflow;
    }

    public static Map<String, String> getMetadata(Workflow workflow) {
        HashMap metadata = workflow.getMetadata();
        if (metadata == null) {
            metadata = new HashMap();
            workflow.setMetadata(metadata);
        }
        return metadata;
    }

    private static BaseObjectMapper deserializer(BaseObjectMapper objectMapper) {
        ExtensionDeserializer deserializer = objectMapper.getWorkflowModule().getExtensionDeserializer();
        deserializer.addExtension("workflow-uri-definitions", URIDefinitions.class);
        deserializer.addExtension("workflow-function-namespaces", FunctionNamespaces.class);
        deserializer.addExtension("workflow-output-schema", OutputSchema.class);
        return objectMapper;
    }

    private static BaseObjectMapper serializer(BaseObjectMapper objectMapper) {
        ExtensionSerializer serializer = objectMapper.getWorkflowModule().getExtensionSerializer();
        serializer.addExtension("workflow-uri-definitions", URIDefinitions.class);
        serializer.addExtension("workflow-function-namespaces", FunctionNamespaces.class);
        serializer.addExtension("workflow-output-schema", OutputSchema.class);
        return objectMapper;
    }

    public static String getFunctionPrefix(FunctionDefinition function) {
        return APP_PROPERTIES_FUNCTIONS_BASE + function.getName();
    }

    public static <T> Supplier<Expression> runtimeRestApi(FunctionDefinition function, String metadataKey, KogitoBuildContext context, Class<T> clazz, T defaultValue) {
        return ServerlessWorkflowUtils.runtimeResolveMetadata(ServerlessWorkflowUtils.getFunctionPrefix(function), metadataKey, clazz, ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context, clazz, defaultValue), ConfigWorkItemSupplier::new);
    }

    public static Supplier<Expression> runtimeRestApi(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        return ServerlessWorkflowUtils.runtimeRestApi(function, metadataKey, context, String.class, null);
    }

    public static <T> Supplier<Expression> runtimeResolveMetadata(String prefix, String metadataKey, Class<T> clazz, T defaultValue, ExpressionBuilder<T> builder) {
        return builder.create(ServerlessWorkflowUtils.getPropKey(prefix, metadataKey), clazz, defaultValue);
    }

    public static String getPropKey(String prefix, String key) {
        return prefix + "." + key;
    }

    public static String resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        return ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context, String.class, "");
    }

    public static <T> T resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context, Class<T> clazz, T defaultValue) {
        return function.getMetadata() != null && function.getMetadata().containsKey(metadataKey) ? clazz.cast(function.getMetadata().get(metadataKey)) : context.getApplicationProperty(ServerlessWorkflowUtils.getPropKey(ServerlessWorkflowUtils.getFunctionPrefix(function), metadataKey), clazz).orElse(defaultValue);
    }

    public static String removeExt(String fileName) {
        return fileName.replaceFirst(REGEX_NO_EXT, "");
    }

    public static String onlyChars(String name) {
        return ServerlessWorkflowUtils.filterString(name, Character::isLetter, Optional.empty());
    }

    public static String replaceNonAlphanumeric(String name) {
        return ServerlessWorkflowUtils.filterString(name, Character::isLetterOrDigit, Optional.of(() -> Character.valueOf('_')));
    }

    public static <T extends Extension> Optional<T> getExtension(Workflow workflow, Class<T> extensionClass) {
        return workflow.getExtensions().stream().filter(extensionClass::isInstance).findFirst().map(extensionClass::cast);
    }

    public static String getValidIdentifier(String name) {
        return ServerlessWorkflowUtils.filterString(name, Character::isJavaIdentifierPart, Optional.empty());
    }

    protected static String filterString(String str, Predicate<Character> p, Optional<Supplier<Character>> replacer) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (p.test(Character.valueOf(c))) {
                sb.append(c);
                continue;
            }
            replacer.ifPresent(r -> sb.append(r.get()));
        }
        return sb.toString();
    }

    public static ModelMetaData getModelMetadata(WorkflowProcess process) {
        return ServerlessWorkflowUtils.getModelMetadata(process, JsonNodeModel.class);
    }

    private static ModelMetaData getModelMetadata(WorkflowProcess process, Class<?> modelClass) {
        return new ModelMetaData(process.getId(), modelClass.getPackage().getName(), modelClass.getSimpleName(), "Public", VariableDeclarations.of(Collections.emptyMap()), false);
    }

    public static <T, V> Map<V, Integer> findDuplicates(List<T> items, Function<T, V> converter) {
        if (items == null) {
            return Map.of();
        }
        LinkedHashMap duplicates = new LinkedHashMap();
        HashSet helper = new HashSet();
        items.forEach(item -> {
            Object toAdd = converter.apply(item);
            if (!helper.add(toAdd)) {
                duplicates.compute(toAdd, (k, v) -> {
                    int n;
                    if (v == null) {
                        n = 2;
                    } else {
                        v = v + 1;
                        n = v;
                    }
                    return n;
                });
            }
        });
        return duplicates;
    }

    public static interface ExpressionBuilder<T> {
        public Supplier<Expression> create(String var1, Class<T> var2, T var3);
    }
}

