/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.events.EventRef;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.sleep.Sleep;
import java.time.Duration;
import java.util.Optional;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.serverless.workflow.actions.WorkflowLogLevel;
import org.kie.kogito.serverless.workflow.fluent.EventDefBuilder;
import org.kie.kogito.serverless.workflow.fluent.FunctionBuilder;
import org.kie.kogito.serverless.workflow.fluent.WorkflowBuilder;
import org.kie.kogito.serverless.workflow.models.JsonNodeModel;

public class ActionBuilder {
    private Action action;
    private Optional<FunctionBuilder> functionDefinition = Optional.empty();
    private Optional<EventDefBuilder> eventDefinition = Optional.empty();

    final Optional<FunctionBuilder> getFunction() {
        return this.functionDefinition;
    }

    final Optional<EventDefBuilder> getEvent() {
        return this.eventDefinition;
    }

    public static ActionBuilder call(String functionName) {
        return ActionBuilder.call(functionName, (JsonNode)NullNode.instance);
    }

    public static ActionBuilder call(FunctionBuilder functionBuilder) {
        return ActionBuilder.call(functionBuilder, (JsonNode)NullNode.instance);
    }

    public static ActionBuilder call(String functionName, Object args) {
        return ActionBuilder.call(functionName, JsonObjectUtils.fromValue((Object)args));
    }

    public static ActionBuilder trigger(EventDefBuilder builder, String data) {
        ActionBuilder actionBuilder = new ActionBuilder(new Action().withEventRef(new EventRef().withData(data).withTriggerEventRef(builder.getName())));
        actionBuilder.eventDefinition = Optional.of(builder);
        return actionBuilder;
    }

    public static ActionBuilder call(FunctionBuilder functionBuilder, JsonNode args) {
        ActionBuilder actionBuilder = ActionBuilder.call(functionBuilder.getName(), args);
        actionBuilder.functionDefinition = Optional.of(functionBuilder);
        return actionBuilder;
    }

    public static ActionBuilder script(String source, ScriptType type) {
        return ActionBuilder.script(source, type, WorkflowBuilder.jsonObject());
    }

    public static ActionBuilder script(String source, ScriptType type, ObjectNode args) {
        return ActionBuilder.call(FunctionBuilder.def(type.toString(), FunctionDefinition.Type.CUSTOM, "script:" + type.toString()), (JsonNode)args.put("script", source));
    }

    public static ActionBuilder call(FunctionBuilder functionBuilder, Object args) {
        return ActionBuilder.call(functionBuilder, JsonObjectUtils.fromValue((Object)args));
    }

    public static ActionBuilder call(FunctionBuilder functionBuilder, Object first, Object second, Object ... extras) {
        ObjectNode node = ObjectMapperFactory.get().createObjectNode();
        node.set("arg1", JsonObjectUtils.fromValue((Object)first));
        node.set("arg2", JsonObjectUtils.fromValue((Object)second));
        int i = 3;
        for (Object extra : extras) {
            node.set("arg" + i++, JsonObjectUtils.fromValue((Object)extra));
        }
        return ActionBuilder.call(functionBuilder, (JsonNode)node);
    }

    public static ActionBuilder call(String functionName, JsonNode args) {
        return new ActionBuilder(new Action().withFunctionRef(new FunctionRef().withRefName(functionName).withArguments(args)));
    }

    public static ActionBuilder log(String functionName, String message) {
        return ActionBuilder.call(functionName, ActionBuilder.logArgs(message));
    }

    public static ActionBuilder log(WorkflowLogLevel logLevel, String message) {
        return ActionBuilder.call(FunctionBuilder.log("log-" + logLevel, logLevel), ActionBuilder.logArgs(message));
    }

    private static JsonNode logArgs(String message) {
        return WorkflowBuilder.jsonObject().put("message", message);
    }

    public static ActionBuilder subprocess(Process<JsonNodeModel> subprocess) {
        return new ActionBuilder(new Action().withSubFlowRef(new SubFlowRef().withWorkflowId(subprocess.id())));
    }

    protected ActionBuilder(Action action) {
        this.action = action;
    }

    public ActionBuilder sleepBefore(Duration duration) {
        this.action.withSleep(new Sleep().withBefore(duration.toString()));
        return this;
    }

    public ActionBuilder sleepAfter(Duration duration) {
        this.action.withSleep(new Sleep().withAfter(duration.toString()));
        return this;
    }

    public ActionBuilder name(String name) {
        this.action.withName(name);
        return this;
    }

    public ActionBuilder condition(String expr) {
        this.action.withCondition(expr);
        return this;
    }

    public Action build() {
        return this.action;
    }

    private ActionDataFilter getFilter() {
        ActionDataFilter actionFilter = this.action.getActionDataFilter();
        if (actionFilter == null) {
            actionFilter = new ActionDataFilter();
            this.action.withActionDataFilter(actionFilter);
        }
        return actionFilter;
    }

    public ActionBuilder noResult() {
        this.getFilter().withUseResults(false);
        return this;
    }

    public ActionBuilder inputFilter(String expr) {
        this.getFilter().withFromStateData(expr);
        return this;
    }

    public ActionBuilder resultFilter(String expr) {
        this.getFilter().withResults(expr);
        return this;
    }

    public ActionBuilder outputFilter(String expr) {
        this.getFilter().withToStateData(expr);
        return this;
    }

    public static enum ScriptType {
        PYTHON,
        JAVA;

    }
}

