/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.filters.EventDataFilter;
import java.util.ArrayList;
import java.util.List;
import org.kie.kogito.serverless.workflow.fluent.ActionBuilder;
import org.kie.kogito.serverless.workflow.fluent.EventDefBuilder;
import org.kie.kogito.serverless.workflow.fluent.EventStateBuilder;

public class EventBranchBuilder {
    private EventStateBuilder parent;
    private List<Action> actions = new ArrayList<Action>();
    private List<String> eventsRef = new ArrayList<String>();
    private OnEvents onEvents;

    public EventBranchBuilder(EventStateBuilder parent, OnEvents onEvents) {
        this.parent = parent;
        this.onEvents = onEvents.withActions(this.actions).withEventRefs(this.eventsRef);
    }

    public EventBranchBuilder action(ActionBuilder action) {
        action.getFunction().ifPresent(this.parent.getFunctions()::add);
        action.getEvent().ifPresent(this.parent.getEvents()::add);
        this.actions.add(action.build());
        return this;
    }

    private EventDataFilter getFilter() {
        EventDataFilter eventFilter = this.onEvents.getEventDataFilter();
        if (eventFilter == null) {
            eventFilter = new EventDataFilter();
            this.onEvents.withEventDataFilter(eventFilter);
        }
        return eventFilter;
    }

    public EventBranchBuilder data(String expr) {
        this.getFilter().withData(expr);
        return this;
    }

    public EventBranchBuilder outputFilter(String expr) {
        this.getFilter().withToStateData(expr);
        return this;
    }

    public EventBranchBuilder event(EventDefBuilder event) {
        this.parent.getEvents().add(event);
        this.eventsRef.add(event.getName());
        return this;
    }

    public EventStateBuilder endBranch() {
        return this.parent;
    }
}

