/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.timeouts.StateExecTimeout;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import org.kie.kogito.serverless.workflow.fluent.ActionBuilder;
import org.kie.kogito.serverless.workflow.fluent.CallbackStateBuilder;
import org.kie.kogito.serverless.workflow.fluent.EventDefBuilder;
import org.kie.kogito.serverless.workflow.fluent.EventStateBuilder;
import org.kie.kogito.serverless.workflow.fluent.ForEachStateBuilder;
import org.kie.kogito.serverless.workflow.fluent.FunctionBuilder;
import org.kie.kogito.serverless.workflow.fluent.InjectStateBuilder;
import org.kie.kogito.serverless.workflow.fluent.OperationStateBuilder;
import org.kie.kogito.serverless.workflow.fluent.ParallelStateBuilder;

public abstract class StateBuilder<T extends StateBuilder<T, S>, S extends DefaultState> {
    protected final S state;
    protected final Collection<FunctionBuilder> functionDefinitions = new HashSet<FunctionBuilder>();
    protected final Collection<EventDefBuilder> eventDefinitions = new HashSet<EventDefBuilder>();
    private short buildCount;
    private static int counter;

    public static InjectStateBuilder inject(JsonNode data) {
        return new InjectStateBuilder(data);
    }

    public static OperationStateBuilder operation() {
        return new OperationStateBuilder();
    }

    public static ParallelStateBuilder parallel() {
        return new ParallelStateBuilder();
    }

    public static CallbackStateBuilder callback(ActionBuilder action, EventDefBuilder event) {
        return new CallbackStateBuilder(event, action);
    }

    public static EventStateBuilder event() {
        return new EventStateBuilder();
    }

    public static ForEachStateBuilder forEach(String inputExpr) {
        return new ForEachStateBuilder(inputExpr);
    }

    Collection<FunctionBuilder> getFunctions() {
        return this.functionDefinitions;
    }

    Collection<EventDefBuilder> getEvents() {
        return this.eventDefinitions;
    }

    protected StateBuilder(S state) {
        this.state = state;
    }

    public T name(String name) {
        this.state.withName(name);
        return (T)this;
    }

    public T stateTimeout(Duration duration) {
        this.timeouts().withStateExecTimeout(new StateExecTimeout().withSingle(duration.toString()));
        return (T)this;
    }

    public T eventTimeout(Duration duration) {
        this.timeouts().withEventTimeout(duration.toString());
        return (T)this;
    }

    private TimeoutsDefinition timeouts() {
        TimeoutsDefinition timeouts = this.state.getTimeouts();
        if (timeouts == null) {
            timeouts = new TimeoutsDefinition();
            this.state.withTimeouts(timeouts);
        }
        return timeouts;
    }

    private StateDataFilter getFilter() {
        StateDataFilter filter = this.state.getStateDataFilter();
        if (filter == null) {
            filter = new StateDataFilter();
            this.state.withStateDataFilter(filter);
        }
        return filter;
    }

    public T inputFilter(String filter) {
        this.getFilter().withInput(filter);
        return (T)this;
    }

    public T outputFilter(String filter) {
        this.getFilter().withOutput(filter);
        return (T)this;
    }

    public S build() {
        this.buildCount = (short)(this.buildCount + 1);
        return StateBuilder.ensureName(this.state);
    }

    short buildCount() {
        return this.buildCount;
    }

    protected static <T extends DefaultState> T ensureName(T state) {
        if (state.getName() == null) {
            state.setName(state.getType() + "_" + counter++);
        }
        return state;
    }
}

