/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.ArrayList;
import org.kie.kogito.serverless.workflow.fluent.ConditionTransitionBuilder;
import org.kie.kogito.serverless.workflow.fluent.DefaultConditionTransitionBuilder;
import org.kie.kogito.serverless.workflow.fluent.StateBuilder;
import org.kie.kogito.serverless.workflow.fluent.WorkflowBuilder;

public class TransitionBuilder<T> {
    private final T container;
    private final WorkflowBuilder workflow;
    private SwitchState switchState;
    private DefaultState lastState;

    protected TransitionBuilder(T container, WorkflowBuilder workflow, DefaultState lastState) {
        this.container = container;
        this.workflow = workflow;
        this.lastState = lastState;
    }

    public TransitionBuilder<T> next(StateBuilder<?, ?> stateBuilder) {
        Object state = stateBuilder.build();
        if (stateBuilder.buildCount() == 1) {
            this.workflow.addFunctions(stateBuilder.getFunctions());
            this.workflow.addEvents(stateBuilder.getEvents());
        }
        this.next((DefaultState)state);
        this.lastState = state;
        return this;
    }

    public TransitionBuilder<TransitionBuilder<T>> when(String expr) {
        ArrayList<DataCondition> conditions;
        if (this.switchState == null) {
            this.switchState = StateBuilder.ensureName(new SwitchState().withType(DefaultState.Type.SWITCH));
            conditions = new ArrayList<DataCondition>();
            this.switchState.withDataConditions(conditions);
            this.next((DefaultState)this.switchState);
        } else {
            conditions = this.switchState.getDataConditions();
        }
        DataCondition condition = new DataCondition().withCondition(expr);
        conditions.add(condition);
        return new ConditionTransitionBuilder(this, this.workflow, this.lastState, condition);
    }

    public TransitionBuilder<T> or() {
        if (this.switchState == null) {
            throw new IllegalArgumentException("or should not be invoked before when");
        }
        DefaultConditionDefinition condition = new DefaultConditionDefinition();
        this.switchState.setDefaultCondition(condition);
        return new DefaultConditionTransitionBuilder<T>(this.container, this.workflow, this.lastState, condition);
    }

    public T end() {
        return this.end(new End());
    }

    protected void addEnd(End end) {
        if (this.lastState.getTransition() == null) {
            this.lastState.withEnd(end);
        }
    }

    public T end(End end) {
        this.addEnd(end);
        return this.container;
    }

    private void next(DefaultState state) {
        this.addTransition(state);
        this.workflow.addState(state);
    }

    protected void addTransition(DefaultState state) {
        if (this.lastState.getTransition() != null || this.lastState.getEnd() != null) {
            throw new IllegalArgumentException("Trying to add transition to an state " + state + " that already has one");
        }
        this.lastState.setTransition(new Transition().withNextState(state.getName()));
    }
}

