/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.workitems.impl.DefaultKogitoWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowWorkItemHandler
extends DefaultKogitoWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowWorkItemHandler.class);

    public Optional<WorkItemTransition> activateWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(workItem.getParameters());
        parameters.remove("Parameter");
        logger.debug("Workflow workitem {} will be invoked with parameters {}", (Object)workItem.getName(), parameters);
        Map<String, JsonNode> params = Collections.singletonMap("Result", JsonObjectUtils.fromValue((Object)this.internalExecute(workItem, parameters)));
        return Optional.of(this.workItemLifeCycle.newTransition("complete", workItem.getPhaseStatus(), params, new Policy[0]));
    }

    protected abstract Object internalExecute(KogitoWorkItem var1, Map<String, Object> var2);

    protected static <C> C safeCast(Object obj, Class<C> clazz) {
        return obj == null || clazz.isAssignableFrom(obj.getClass()) ? clazz.cast(obj) : WorkflowWorkItemHandler.tryConvert(obj, clazz);
    }

    private static <C> C tryConvert(Object obj, Class<C> clazz) {
        if (Number.class.isAssignableFrom(clazz) && Number.class.isAssignableFrom(obj.getClass())) {
            Number number = (Number)obj;
            if (Integer.class.isAssignableFrom(clazz)) {
                return clazz.cast(number.intValue());
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return clazz.cast(number.longValue());
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return clazz.cast(number.doubleValue());
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return clazz.cast(Float.valueOf(number.floatValue()));
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return clazz.cast(number.shortValue());
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return clazz.cast(number.byteValue());
            }
            throw new UnsupportedOperationException("Type " + clazz + " is not supported");
        }
        throw new ClassCastException("OpenAPI expect type " + clazz + " but argument " + obj + " is of type " + obj.getClass());
    }

    protected static <V> V buildBody(Map<String, Object> params, Class<V> clazz) {
        for (Object obj : params.values()) {
            if (obj == null || !clazz.isAssignableFrom(obj.getClass())) continue;
            logger.trace("Invoking workitemhandler with value {}", obj);
            return WorkflowWorkItemHandler.safeCast(obj, clazz);
        }
        Object value = JsonObjectUtils.convertValue(params, clazz);
        logger.trace("Invoking workitemhandler with value {}", value);
        return (V)value;
    }
}

