/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;

public class JsonNodeContext
implements AutoCloseable {
    private final JsonNode jsonNode;
    private final Set<String> keys;

    public static Stream<Variable> getEvalVariables(Node node) {
        if (node instanceof ForEachNode) {
            node = ((ForEachNode)node).getCompositeNode();
        }
        if (node instanceof ContextContainer) {
            return JsonNodeContext.getEvalVariables((ContextContainer)node);
        }
        return Stream.empty();
    }

    private static Stream<Variable> getEvalVariables(ContextableInstance containerInstance) {
        return containerInstance instanceof ContextInstanceContainer ? JsonNodeContext.getEvalVariables(((ContextInstanceContainer)containerInstance).getContextContainer()) : Stream.empty();
    }

    private static Stream<Variable> getEvalVariables(ContextContainer container) {
        VariableScope variableScope = (VariableScope)container.getDefaultContext("VariableScope");
        return variableScope.getVariables().stream().filter(v -> v.getMetaData("evalVariable") != null);
    }

    public static JsonNodeContext from(JsonNode jsonNode, KogitoProcessContext context) {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            JsonNodeContext.addVariablesFromContext(objectNode, context, map);
        }
        return new JsonNodeContext(jsonNode, map.keySet());
    }

    public JsonNode getNode() {
        return this.jsonNode;
    }

    private JsonNodeContext(JsonNode jsonNode, Set<String> keys) {
        this.jsonNode = jsonNode;
        this.keys = keys;
    }

    private static void addVariablesFromContext(ObjectNode jsonNode, KogitoProcessContext processInfo, Map<String, JsonNode> variables) {
        KogitoNodeInstance nodeInstance = processInfo.getNodeInstance();
        if (nodeInstance != null) {
            NodeInstanceContainer container;
            NodeInstanceContainer nodeInstanceContainer = container = nodeInstance instanceof NodeInstanceContainer ? (NodeInstanceContainer)nodeInstance : nodeInstance.getNodeInstanceContainer();
            while (container instanceof ContextableInstance) {
                JsonNodeContext.getVariablesFromContext(jsonNode, (ContextableInstance)container, variables);
                container = container instanceof KogitoNodeInstance ? ((KogitoNodeInstance)container).getNodeInstanceContainer() : null;
            }
        }
        variables.forEach((arg_0, arg_1) -> ((ObjectNode)jsonNode).set(arg_0, arg_1));
    }

    private static void getVariablesFromContext(ObjectNode jsonNode, ContextableInstance node, Map<String, JsonNode> variables) {
        VariableScopeInstance variableScope = (VariableScopeInstance)node.getContextInstance("VariableScope");
        if (variableScope != null) {
            Collection evalVariables = JsonNodeContext.getEvalVariables(node).map(Variable::getName).collect(Collectors.toList());
            for (Map.Entry e : variableScope.getVariables().entrySet()) {
                if (!evalVariables.contains(e.getKey()) && (!(node instanceof WorkflowProcessInstance) || Objects.equals(jsonNode, e.getValue()))) continue;
                variables.putIfAbsent((String)e.getKey(), JsonObjectUtils.fromValue(e.getValue()));
            }
        }
    }

    @Override
    public void close() {
        if (!this.keys.isEmpty()) {
            this.keys.forEach(arg_0 -> ((ObjectNode)((ObjectNode)this.jsonNode)).remove(arg_0));
        }
    }
}

