/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesHelper {
    private static final Set<String> PREDEFINED_KEYS = Set.of("workflowdata", "workflowdatainput");
    private static final Logger logger = LoggerFactory.getLogger(VariablesHelper.class);

    private VariablesHelper() {
    }

    public static Map<String, JsonNode> getAdditionalVariables(KogitoProcessContext context) {
        HashMap<String, JsonNode> variables = new HashMap<String, JsonNode>();
        KogitoNodeInstance nodeInstance = context.getNodeInstance();
        if (nodeInstance != null) {
            NodeInstanceContainer container;
            NodeInstanceContainer nodeInstanceContainer = container = nodeInstance instanceof NodeInstanceContainer ? (NodeInstanceContainer)nodeInstance : nodeInstance.getNodeInstanceContainer();
            while (container instanceof ContextableInstance) {
                VariablesHelper.addVariablesFromContext((ContextableInstance)container, variables);
                container = container instanceof KogitoNodeInstance ? ((KogitoNodeInstance)container).getNodeInstanceContainer() : null;
            }
        }
        logger.debug("Additional variables for expression evaluation are {}", variables);
        return variables;
    }

    public static Stream<Variable> getEvalVariables(Node node) {
        if (node instanceof ForEachNode) {
            node = ((ForEachNode)node).getCompositeNode();
        }
        if (node instanceof ContextContainer) {
            return VariablesHelper.getEvalVariables((ContextContainer)node);
        }
        return Stream.empty();
    }

    private static Stream<Variable> getEvalVariables(ContextableInstance containerInstance) {
        return containerInstance instanceof ContextInstanceContainer ? VariablesHelper.getEvalVariables(((ContextInstanceContainer)containerInstance).getContextContainer()) : Stream.empty();
    }

    private static Stream<Variable> getEvalVariables(ContextContainer container) {
        VariableScope variableScope = (VariableScope)container.getDefaultContext("VariableScope");
        return variableScope.getVariables().stream().filter(VariablesHelper::isEvalVariable);
    }

    private static boolean isEvalVariable(Variable v) {
        Object isEval = v.getMetaData("evalVariable");
        return isEval instanceof Boolean ? (Boolean)isEval : false;
    }

    private static void addVariablesFromContext(ContextableInstance node, Map<String, JsonNode> variables) {
        VariableScopeInstance variableScope = (VariableScopeInstance)node.getContextInstance("VariableScope");
        if (variableScope != null) {
            Collection evalVariables = VariablesHelper.getEvalVariables(node).map(Variable::getName).collect(Collectors.toList());
            for (Map.Entry e : variableScope.getVariables().entrySet()) {
                if (!evalVariables.contains(e.getKey()) && (!(node instanceof WorkflowProcessInstance) || PREDEFINED_KEYS.contains(e.getKey()))) continue;
                variables.putIfAbsent((String)e.getKey(), JsonObjectUtils.fromValue(e.getValue()));
            }
        }
    }
}

