/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.test.resources.ConditionalSpringBootTestResource;
import org.kie.kogito.testcontainers.KogitoKeycloakContainer;

public class KeycloakSpringBootTestResource
extends ConditionalSpringBootTestResource<KogitoKeycloakContainer> {
    public static final String KOGITO_KEYCLOAK_PROPERTY = "keycloak.auth-server-url";
    public static final String OAUTH2_JWT_ISSUER = "spring.security.oauth2.resourceserver.jwt.issuer-uri";

    public KeycloakSpringBootTestResource() {
        super(new KogitoKeycloakContainer());
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(KOGITO_KEYCLOAK_PROPERTY, String.format("http://localhost:%s", ((KogitoKeycloakContainer)this.getTestResource()).getMappedPort()));
        properties.put(OAUTH2_JWT_ISSUER, String.format("http://localhost:%s/realms/%s", ((KogitoKeycloakContainer)this.getTestResource()).getMappedPort(), "kogito"));
        return properties;
    }

    public static class Conditional
    extends KeycloakSpringBootTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

