/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.Optional;
import java.util.function.Consumer;
import org.kie.kogito.testcontainers.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public abstract class KogitoGenericContainer<T extends GenericContainer<T>>
extends GenericContainer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoGenericContainer.class);

    public KogitoGenericContainer(String containerName) {
        super(KogitoGenericContainer.getImageName(containerName));
        this.withStartupTimeout(Constants.CONTAINER_START_TIMEOUT);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withLogConsumer(f -> System.out.print(f.getUtf8String()));
    }

    public static String getImageName(String containerName) {
        String propertyName = "container.image." + containerName;
        return Optional.ofNullable(System.getProperty(propertyName)).filter(s -> s != null && s.trim().length() > 0).orElseThrow(() -> new IllegalArgumentException(propertyName + " property should be set in pom.xml"));
    }
}

