/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;

public class KogitoImageNameSubstitutor
extends ImageNameSubstitutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoImageNameSubstitutor.class);

    public DockerImageName apply(DockerImageName original) {
        LOGGER.debug("Original Docker image used by TestContainers: {}", (Object)original);
        String canonicalName = original.asCanonicalNameString();
        if (canonicalName.startsWith("mongo:")) {
            return this.getMongoImageSubstitute(canonicalName);
        }
        return original;
    }

    private DockerImageName getMongoImageSubstitute(String canonicalName) {
        return DockerImageName.parse((String)("library/" + canonicalName)).asCompatibleSubstituteFor("mongo");
    }

    protected String getDescription() {
        return "Kogito Image Name Substitutor";
    }
}

