/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.text.MessageFormat;
import java.util.function.Consumer;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class KogitoOracleSqlContainer
extends OracleContainer
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoOracleSqlContainer.class);
    public static final String ORACLE_CONNECTION_URI = "kogito.persistence.oracle.connection.uri";

    public KogitoOracleSqlContainer() {
        super("oracleinanutshell/oracle-xe-11g");
        this.withLogConsumer(this.getLogger());
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withStartupTimeout(Constants.CONTAINER_START_TIMEOUT);
    }

    private Consumer<OutputFrame> getLogger() {
        return f -> System.out.print(f.getUtf8String());
    }

    @Override
    public void start() {
        super.start();
        LOGGER.info("Oracle server: {}", (Object)(this.getContainerIpAddress() + ":" + this.getOraclePort()));
    }

    @Override
    public int getMappedPort() {
        return this.getOraclePort();
    }

    @Override
    public String getResourceName() {
        return "oracle";
    }

    public String getReactiveUrl() {
        String connectionTemplate = "oracle://{0}:{1}@{2}:{3}/{4}?search_path={5}";
        String user = this.getUsername();
        String server = this.getHost();
        String secret = this.getPassword();
        String port = String.valueOf(this.getMappedPort());
        String database = this.getDatabaseName();
        String schema = "public";
        return MessageFormat.format("oracle://{0}:{1}@{2}:{3}/{4}?search_path={5}", user, secret, server, port, database, "public");
    }

    @Override
    public void stop() {
        super.stop();
    }
}

