/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.test.resources.ConditionHolder;

public class ConditionHolderTest {
    private static final String RESOURCE_NAME = "my-test-resource";
    private static final String RESOURCE_PROPERTY = String.format("enable.resource.%s", "my-test-resource");
    private ConditionHolder condition;

    @BeforeEach
    public void setup() {
        this.condition = new ConditionHolder(RESOURCE_NAME);
    }

    @Test
    public void shouldBeEnabledByDefault() {
        Assertions.assertThat((boolean)this.condition.isEnabled()).isTrue();
    }

    @Test
    public void shouldBeDisabledIfSystemPropertyDoesNotExist() {
        System.clearProperty(RESOURCE_PROPERTY);
        this.condition.enableConditional();
        Assertions.assertThat((boolean)this.condition.isEnabled()).isFalse();
    }

    @Test
    public void shouldBeDisabledIfSystemPropertyIsNotTrue() {
        System.setProperty(RESOURCE_PROPERTY, "anything");
        this.condition.enableConditional();
        Assertions.assertThat((boolean)this.condition.isEnabled()).isFalse();
    }

    @Test
    public void shouldBeEnabledIfSystemPropertyIsTrue() {
        System.setProperty(RESOURCE_PROPERTY, "true");
        this.condition.enableConditional();
        Assertions.assertThat((boolean)this.condition.isEnabled()).isTrue();
    }
}

