/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.utils;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;

public final class SocketUtils {
    static final int PORT_RANGE_MIN = 49152;
    static final int PORT_RANGE_MAX = 65535;
    private static final SecureRandom RND = new SecureRandom();

    private SocketUtils() {
    }

    public static int findAvailablePort() {
        int candidatePort;
        int portRange = 16383;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available port in the range [%d, %d] after %d attempts", 49152, 65535, searchCounter));
            }
            candidatePort = SocketUtils.findRandomPort(49152, 65535);
            ++searchCounter;
        } while (!SocketUtils.isPortAvailable(candidatePort));
        return candidatePort;
    }

    private static int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + RND.nextInt(portRange + 1);
    }

    private static boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

