/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.nio.charset.StandardCharsets;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;

public class KogitoKafkaContainer
extends KogitoGenericContainer<KogitoKafkaContainer>
implements TestResource {
    public static final String NAME = "kafka";
    public static final String KAFKA_PROPERTY = "container.image.kafka";
    public static final int KAFKA_PORT = 9092;
    private static final String STARTER_SCRIPT = "/var/lib/redpanda/redpanda.sh";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoKafkaContainer.class);

    public KogitoKafkaContainer() {
        super(NAME);
        this.withExposedPorts(new Integer[]{9092});
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh"}));
        this.withCommand(new String[]{"-c", "while [ ! -f /var/lib/redpanda/redpanda.sh ]; do sleep 0.1; done; /var/lib/redpanda/redpanda.sh"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Kafka API server.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        String brokerAdvertisedListener = this.brokerAdvertisedListener(containerInfo);
        Object command = "#!/bin/bash\n";
        command = (String)command + "/usr/bin/rpk redpanda start --check=false --node-id 0 --smp 1 ";
        command = (String)command + "--memory 1G --overprovisioned --reserve-memory 0M ";
        command = (String)command + "--kafka-addr PLAINTEXT://0.0.0.0:29092,OUTSIDE://0.0.0.0:9092 ";
        command = (String)command + String.format("--advertise-kafka-addr %s ", String.join((CharSequence)",", this.getBootstrapServers(), brokerAdvertisedListener));
        command = (String)command + "--set redpanda.enable_idempotence=true ";
        command = (String)command + "--set redpanda.enable_transactions=true ";
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)511), STARTER_SCRIPT);
    }

    @Override
    public void start() {
        super.start();
        LOGGER.info("Kafka servers: {}", (Object)this.getBootstrapServers());
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("PLAINTEXT://%s:29092", containerInfo.getConfig().getHostName());
    }

    public String getBootstrapServers() {
        return String.format("OUTSIDE://%s:%d", this.getHost(), this.getMappedPort(9092));
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(9092);
    }

    @Override
    public String getResourceName() {
        return NAME;
    }
}

