/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.utils;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;

public class ProcessInstancesTestUtils {
    public static <T> ProcessInstance<T> getFirst(ProcessInstances<T> processInstances) {
        try (Stream stream = processInstances.stream();){
            ProcessInstance processInstance = (ProcessInstance)stream.findFirst().orElseThrow();
            return processInstance;
        }
    }

    public static <T> void abortFirst(ProcessInstances<T> processInstances) {
        try (Stream stream = processInstances.stream(ProcessInstanceReadMode.MUTABLE);){
            ((ProcessInstance)stream.findFirst().get()).abort();
        }
    }

    public static <T> void abort(ProcessInstances<T> processInstances) {
        try (Stream stream = processInstances.stream(ProcessInstanceReadMode.MUTABLE);){
            stream.forEach(ProcessInstance::abort);
        }
    }

    public static <T> void assertEmpty(ProcessInstances<T> processInstances) {
        try (Stream stream = processInstances.stream();){
            Assertions.assertThat((Stream)stream).isEmpty();
        }
    }

    public static <T> void assertOne(ProcessInstances<T> processInstances) {
        try (Stream stream = processInstances.stream();){
            Assertions.assertThat((Stream)stream).hasSize(1);
        }
    }

    public static <T> void assertOne(ProcessInstances<T> processInstances, ProcessInstanceReadMode mode) {
        ProcessInstancesTestUtils.assertSize(processInstances, mode, 1);
    }

    public static <T> void assertSize(ProcessInstances<T> processInstances, ProcessInstanceReadMode mode, int size) {
        try (Stream stream = processInstances.stream(mode);){
            Assertions.assertThat((Stream)stream).hasSize(size);
        }
    }
}

