/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoRedisSearchContainer;
import org.mockito.Mockito;

public class KogitoRedisSearchContainerTest {
    private static final int MAPPED_PORT = 6379;
    private static final String IMAGE = "my-redis-image";
    private KogitoRedisSearchContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.redis", IMAGE);
        this.container = (KogitoRedisSearchContainer)Mockito.spy((Object)new KogitoRedisSearchContainer());
        ((KogitoRedisSearchContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoRedisSearchContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertTrue((boolean)this.container.getExposedPorts().contains(6379));
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertEquals((Object)"redis", (Object)this.container.getResourceName());
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoRedisSearchContainer)Mockito.doReturn((Object)6379).when((Object)this.container)).getMappedPort(6379);
        Assertions.assertEquals((int)6379, (int)this.container.getMappedPort());
    }
}

