/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;
import org.mockito.Mockito;

class MongoDBQuarkusTestResourceTest {
    private MongoDBQuarkusTestResource resource;

    MongoDBQuarkusTestResourceTest() {
    }

    @Test
    void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"quarkus.mongodb.connection-string", (Object)this.resource.getKogitoProperty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getKogitoPropertyValue());
    }

    @Test
    void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenConditionalResource() {
        this.resource = (MongoDBQuarkusTestResource)Mockito.spy((Object)new MongoDBQuarkusTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (MongoDBQuarkusTestResource)Mockito.spy((Object)new MongoDBQuarkusTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

