/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.testcontainers.springboot.RedisSpringBootTestResource;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class RedisSpringBootTestResourceTest {
    private static final String IMAGE = "my-redis-image";
    private RedisSpringBootTestResource resource;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.redis", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"kogito.persistence.redis.url", (Object)this.resource.getKogitoProperty());
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenResource() {
        this.resource = new RedisSpringBootTestResource();
    }

    private void givenConditionalResource() {
        this.resource = (RedisSpringBootTestResource)Mockito.spy((Object)new RedisSpringBootTestResource.Conditional());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

