/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.function.Consumer;
import org.kie.kogito.resources.TestResource;
import org.kie.kogito.testcontainers.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KogitoKafkaContainer
extends KafkaContainer
implements TestResource {
    public static final String NAME = "kafka";
    public static final String KAFKA_PROPERTY = "container.image.kafka";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoKafkaContainer.class);

    public KogitoKafkaContainer() {
        super(DockerImageName.parse((String)KogitoKafkaContainer.kafkaImage()));
        this.withLogConsumer(f -> System.out.print(f.getUtf8String()));
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Startup complete.*", (int)2));
        this.withStartupTimeout(Constants.CONTAINER_START_TIMEOUT);
    }

    @Override
    public void start() {
        super.start();
        LOGGER.info("Kafka servers: {}", (Object)this.getBootstrapServers());
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(9093);
    }

    @Override
    public String getResourceName() {
        return NAME;
    }

    private static String kafkaImage() {
        String kafkaImage = System.getProperty(KAFKA_PROPERTY);
        if (kafkaImage == null) {
            throw new IllegalStateException("Please provide 'container.image.kafka' system property");
        }
        return kafkaImage;
    }
}

