/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.resources.ConditionalSpringBootTestResource;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class KafkaSpringBootTestResource
extends ConditionalSpringBootTestResource<KogitoKafkaContainer> {
    public static final String KOGITO_KAFKA_PROPERTY = "spring.kafka.bootstrap-servers";

    public KafkaSpringBootTestResource() {
        super(new KogitoKafkaContainer());
    }

    @Override
    protected String getKogitoProperty() {
        return KOGITO_KAFKA_PROPERTY;
    }

    @Override
    protected void updateBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.updateBeanFactory(beanFactory);
        if (!beanFactory.containsBean(KafkaClient.class.getName())) {
            beanFactory.registerSingleton(KafkaClient.class.getName(), (Object)new KafkaClient("localhost:" + ((KogitoKafkaContainer)this.getTestResource()).getMappedPort()));
        }
    }

    public static class Conditional
    extends KafkaSpringBootTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

