/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources;

import java.util.Map;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.TestResource;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.test.context.support.TestPropertySourceUtils;

public abstract class ConditionalSpringBootTestResource<T extends TestResource>
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
ApplicationListener<ContextClosedEvent> {
    private final T testResource;
    private final ConditionHolder condition;
    private boolean conditionalEnabled = false;

    public ConditionalSpringBootTestResource(T testResource) {
        this(testResource, new ConditionHolder(testResource.getResourceName()));
    }

    public ConditionalSpringBootTestResource(T testResource, ConditionHolder condition) {
        this.testResource = testResource;
        this.condition = condition;
    }

    public T getTestResource() {
        return this.testResource;
    }

    public boolean isConditionalEnabled() {
        return this.conditionalEnabled;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (this.condition.isEnabled()) {
            this.testResource.start();
            this.updateBeanFactory(applicationContext.getBeanFactory());
            String[] props = (String[])this.getProperties().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
            this.updateContextProperty(applicationContext, props);
        }
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.condition.isEnabled()) {
            this.testResource.stop();
        }
    }

    protected abstract Map<String, String> getProperties();

    protected void enableConditional() {
        this.condition.enableConditional();
        this.conditionalEnabled = true;
    }

    protected void updateBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerSingleton(this.testResource.getResourceName() + "ShutDownHook", (Object)this);
    }

    protected void updateContextProperty(ConfigurableApplicationContext applicationContext, String[] props) {
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableApplicationContext)applicationContext, (String[])props);
    }
}

