/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.acme.travels.CompleteProcessListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;

@QuarkusTest
@Disabled(value="currently flaky, waiting on upstream fix Quarkus-side, see https://issues.redhat.com/browse/KOGITO-1543")
public class BoundaryTimersProcessTest {
    @Inject
    Application app;

    @Test
    public void testTimersProcess() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((DefaultProcessEventListenerConfig)this.app.config().process().processEventListeners()).register((ProcessEventListener)new CompleteProcessListener(latch));
        Process timersOnTaskProcess = this.app.processes().processById("timersOnTask");
        Assertions.assertNotNull((Object)timersOnTaskProcess);
        Model m = (Model)timersOnTaskProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delay", "PT3S");
        m.fromMap(parameters);
        ProcessInstance processInstance = timersOnTaskProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        latch.await(2L, TimeUnit.MINUTES);
        Optional exists = timersOnTaskProcess.instances().findById(processInstance.id());
        Assertions.assertFalse((boolean)exists.isPresent());
    }
}

