/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import ch.obermuhlner.math.big.stream.BigDecimalStream;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.BigDecimalHandler;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;

public class BigDecimalHandlerTest {
    private static final String ENDPOINT_NAME = "hello";
    private static final String[] INTERNAL_PROMETHEUS_LABELS = new String[]{DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS[0], DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS[1], "quantile"};
    CollectorRegistry registry;
    BigDecimalHandler handler;

    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new BigDecimalHandler(ENDPOINT_NAME, this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void GivenSomeSamples_WhenQuantilesAreCalculated_ThenTheQuantilesAreCorrect() {
        HashMap<Double, Double> expectedQuantiles = new HashMap<Double, Double>();
        expectedQuantiles.put(0.1, 999.0);
        expectedQuantiles.put(0.25, 2525.0);
        expectedQuantiles.put(0.5, 5042.0);
        expectedQuantiles.put(0.75, 7551.0);
        expectedQuantiles.put(0.9, 9062.0);
        expectedQuantiles.put(0.99, 10000.0);
        BigDecimalStream.range((BigDecimal)BigDecimal.valueOf(1L), (BigDecimal)BigDecimal.valueOf(10001L), (BigDecimal)BigDecimal.ONE, (MathContext)MathContext.DECIMAL64).forEach(x -> this.handler.record("decision", ENDPOINT_NAME, x));
        for (Double key : expectedQuantiles.keySet()) {
            Assertions.assertEquals((double)((Double)expectedQuantiles.get(key)), (double)this.getQuantile("decision", "hello_dmn_result", ENDPOINT_NAME, key), (double)5.0);
        }
    }

    private double getQuantile(String decision, String name, String labelValue, double q) {
        return this.registry.getSampleValue(name, INTERNAL_PROMETHEUS_LABELS, new String[]{decision, labelValue, Collector.doubleToGoString((double)q)});
    }
}

