/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.CollectorRegistry;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.BooleanHandler;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;

public class BooleanHandlerTest {
    private static final String ENDPOINT_NAME = "hello";
    CollectorRegistry registry;
    BooleanHandler handler;

    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new BooleanHandler(ENDPOINT_NAME, this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void GivenSomeBooleanMetrics_WhenMetricsAreStored_ThenTheCountIsCorrect() {
        Double expectedTrue = 3.0;
        Double expectedFalse = 2.0;
        IntStream.rangeClosed(1, 3).forEach(x -> this.handler.record("decision", ENDPOINT_NAME, Boolean.valueOf(true)));
        IntStream.rangeClosed(1, 2).forEach(x -> this.handler.record("decision", ENDPOINT_NAME, Boolean.valueOf(false)));
        Assertions.assertEquals((Double)expectedTrue, (Double)this.getLabelsValue("decision", ENDPOINT_NAME, "true"));
        Assertions.assertEquals((Double)expectedFalse, (Double)this.getLabelsValue("decision", ENDPOINT_NAME, "false"));
    }

    private Double getLabelsValue(String decision, String name, String labelValue) {
        return this.registry.getSampleValue(name + "_dmn_result", DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS, new String[]{decision, name, labelValue});
    }
}

