/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.dmn.rest.DMNResult;
import org.kie.kogito.grafana.dmn.SupportedDecisionTypes;
import org.kie.kogito.monitoring.mocks.DMNDecisionResultMock;
import org.kie.kogito.monitoring.system.metrics.DMNResultMetricsBuilder;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;

public class DMNResultMetricsBuilderTest {
    private static final String ENDPOINT_NAME = "hello";
    CollectorRegistry registry;

    @BeforeEach
    public void setUp() {
        this.registry = CollectorRegistry.defaultRegistry;
    }

    @Test
    public void GivenADMNResult_WhenMetricsAreStored_ThenTheCollectorsAreProperlyWorking() {
        DMNResult dmnResult = new DMNResult();
        ArrayList<DMNDecisionResultMock> decisions = new ArrayList<DMNDecisionResultMock>();
        decisions.add(new DMNDecisionResultMock("AlphabetDecision", "A"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "Hello"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "Hello"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "World"));
        dmnResult.setDecisionResults(decisions);
        boolean expectedAlphabetDecisionA = true;
        int expectedDictionaryDecisionHello = 2;
        boolean expectedDictionaryDecisionWorld = true;
        DMNResultMetricsBuilder.generateMetrics((DMNResult)dmnResult, (String)ENDPOINT_NAME);
        Assertions.assertEquals((double)((double)expectedAlphabetDecisionA), (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "AlphabetDecision", "A"));
        Assertions.assertEquals((double)expectedDictionaryDecisionHello, (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "DictionaryDecision", "Hello"));
        Assertions.assertEquals((double)((double)expectedDictionaryDecisionWorld), (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "DictionaryDecision", "World"));
    }

    @Test
    public void alighmentWithKogitoCodegenIsOk() {
        List addonSupportedTypes = DMNResultMetricsBuilder.getHandlers().values().stream().map(x -> x.getDmnType()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)addonSupportedTypes.containsAll(SupportedDecisionTypes.getSupportedDMNTypes()));
        Assertions.assertTrue((boolean)SupportedDecisionTypes.getSupportedDMNTypes().containsAll(addonSupportedTypes));
    }

    @Test
    public void GivenANullDMNResult_WhenMetricsAreRegistered_ThenTheSampleIsDiscarded() {
        Assertions.assertDoesNotThrow(() -> DMNResultMetricsBuilder.generateMetrics(null, (String)ENDPOINT_NAME));
    }

    private Double getLabelsValue(String name, String decisionName, String labelValue) {
        return this.registry.getSampleValue(name + "_dmn_result", DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS, new String[]{decisionName, ENDPOINT_NAME, labelValue});
    }
}

