/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.CollectorRegistry;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.StringHandler;

public class StringHandlerTest {
    private static final String ENDPOINT_NAME = "hello";
    private static final String DECISION_NAME = "decision";
    CollectorRegistry registry;
    StringHandler handler;

    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new StringHandler(ENDPOINT_NAME, this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void GivenSomeStringMetrics_WhenMetricsAreStored_ThenTheCountIsCorrect() {
        Double expectedCountStringA = 3.0;
        Double expectedCountStringB = 2.0;
        Double expectedCountStringC = 5.0;
        IntStream.rangeClosed(1, 3).forEach(x -> this.handler.record(DECISION_NAME, ENDPOINT_NAME, "A"));
        IntStream.rangeClosed(1, 2).forEach(x -> this.handler.record(DECISION_NAME, ENDPOINT_NAME, "B"));
        IntStream.rangeClosed(1, 5).forEach(x -> this.handler.record(DECISION_NAME, ENDPOINT_NAME, "C"));
        Assertions.assertEquals((Double)expectedCountStringA, (Double)this.getLabelsValue(DECISION_NAME, ENDPOINT_NAME, "A"));
        Assertions.assertEquals((Double)expectedCountStringB, (Double)this.getLabelsValue(DECISION_NAME, ENDPOINT_NAME, "B"));
        Assertions.assertEquals((Double)expectedCountStringC, (Double)this.getLabelsValue(DECISION_NAME, ENDPOINT_NAME, "C"));
    }

    private Double getLabelsValue(String decision, String name, String labelValue) {
        return this.registry.getSampleValue(name + "_dmn_result", DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS, new String[]{decision, name, labelValue});
    }
}

