/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.system.metrics.dmnhandlers;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Summary;
import java.math.BigDecimal;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.TypeHandler;

public class BigDecimalHandler
implements TypeHandler<BigDecimal> {
    private final Summary summary;
    private String dmnType;

    public BigDecimalHandler(String dmnType, CollectorRegistry registry) {
        this.dmnType = dmnType;
        this.summary = this.initializeCounter(dmnType, registry);
    }

    public BigDecimalHandler(String dmnType) {
        this(dmnType, null);
    }

    @Override
    public void record(String decision, String endpointName, BigDecimal sample) {
        ((Summary.Child)this.summary.labels(new String[]{decision, endpointName})).observe(sample.doubleValue());
    }

    @Override
    public String getDmnType() {
        return this.dmnType;
    }

    private Summary initializeCounter(String dmnType, CollectorRegistry registry) {
        Summary.Builder builder = (Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.1, 0.01).quantile(0.25, 0.05).quantile(0.5, 0.05).quantile(0.75, 0.05).quantile(0.9, 0.05).quantile(0.99, 0.01).name(dmnType + "_dmn_result")).help("Decision output.")).labelNames(DecisionConstants.DECISION_ENDPOINT_LABELS);
        return registry == null ? (Summary)builder.register(CollectorRegistry.defaultRegistry) : (Summary)builder.register(registry);
    }
}

