/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.dmn.rest.DMNResult;
import org.kie.kogito.grafana.dmn.SupportedDecisionTypes;
import org.kie.kogito.monitoring.integration.AbstractQuantilesTest;
import org.kie.kogito.monitoring.mocks.DMNDecisionResultMock;
import org.kie.kogito.monitoring.system.metrics.DMNResultMetricsBuilder;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;

public class DMNResultMetricsBuilderTest {
    private static final String ENDPOINT_NAME = "hello";
    CollectorRegistry registry;

    @BeforeEach
    public void setUp() {
        this.registry = CollectorRegistry.defaultRegistry;
    }

    @Test
    public void givenADMNResultWhenMetricsAreStoredThenTheCollectorsAreProperlyWorking() {
        DMNResult dmnResult = new DMNResult();
        ArrayList<DMNDecisionResultMock> decisions = new ArrayList<DMNDecisionResultMock>();
        decisions.add(new DMNDecisionResultMock("AlphabetDecision", "A"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "Hello"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "Hello"));
        decisions.add(new DMNDecisionResultMock("DictionaryDecision", "World"));
        decisions.add(new DMNDecisionResultMock("BooleanDecision", true));
        decisions.add(new DMNDecisionResultMock("LocalDateTimeDecision", LocalDateTime.now()));
        decisions.add(new DMNDecisionResultMock("DaysAndTimeDurationDecision", Duration.ofSeconds(1L)));
        decisions.add(new DMNDecisionResultMock("BigDecimalDecision", new BigDecimal(1)));
        decisions.add(new DMNDecisionResultMock("YearsAndMonthsDecision", Period.ofMonths(12)));
        decisions.add(new DMNDecisionResultMock("LocalDateDecision", LocalDate.of(2020, 1, 1)));
        decisions.add(new DMNDecisionResultMock("LocalTimeDecision", LocalTime.of(12, 0)));
        dmnResult.setDecisionResults(decisions);
        boolean expectedAlphabetDecisionA = true;
        int expectedDictionaryDecisionHello = 2;
        boolean expectedDictionaryDecisionWorld = true;
        boolean expectedTrueBooleanDecision = true;
        DMNResultMetricsBuilder.generateMetrics((DMNResult)dmnResult, (String)ENDPOINT_NAME);
        Assertions.assertEquals((double)((double)expectedAlphabetDecisionA), (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "AlphabetDecision", "A"));
        Assertions.assertEquals((double)expectedDictionaryDecisionHello, (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "DictionaryDecision", "Hello"));
        Assertions.assertEquals((double)((double)expectedDictionaryDecisionWorld), (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(String.class), "DictionaryDecision", "World"));
        Assertions.assertEquals((double)((double)expectedTrueBooleanDecision), (Double)this.getLabelsValue(SupportedDecisionTypes.fromInternalToStandard(Boolean.class), "BooleanDecision", "true"));
        Assertions.assertTrue((this.getQuantile("LocalDateTimeDecision", SupportedDecisionTypes.fromInternalToStandard(LocalDateTime.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getQuantile("DaysAndTimeDurationDecision", SupportedDecisionTypes.fromInternalToStandard(Duration.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getQuantile("BigDecimalDecision", SupportedDecisionTypes.fromInternalToStandard(BigDecimal.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getQuantile("YearsAndMonthsDecision", SupportedDecisionTypes.fromInternalToStandard(Period.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getQuantile("LocalDateDecision", SupportedDecisionTypes.fromInternalToStandard(LocalDate.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getQuantile("LocalTimeDecision", SupportedDecisionTypes.fromInternalToStandard(LocalTime.class), ENDPOINT_NAME, 0.1) >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void alighmentWithKogitoCodegenIsOk() {
        List addonSupportedTypes = DMNResultMetricsBuilder.getHandlers().values().stream().map(x -> x.getDmnType()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)addonSupportedTypes.containsAll(SupportedDecisionTypes.getSupportedDMNTypes()));
        Assertions.assertTrue((boolean)SupportedDecisionTypes.getSupportedDMNTypes().containsAll(addonSupportedTypes));
    }

    @Test
    public void givenANullDMNResultWhenMetricsAreRegisteredThenTheSampleIsDiscarded() {
        Assertions.assertDoesNotThrow(() -> DMNResultMetricsBuilder.generateMetrics(null, (String)ENDPOINT_NAME));
    }

    private Double getLabelsValue(String name, String decisionName, String labelValue) {
        return this.registry.getSampleValue(name + "_dmn_result", DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS, new String[]{decisionName, ENDPOINT_NAME, labelValue});
    }

    private double getQuantile(String decision, String name, String labelValue, double q) {
        return this.registry.getSampleValue(name.replace(" ", "_") + "_dmn_result", AbstractQuantilesTest.INTERNAL_PROMETHEUS_LABELS, new String[]{decision, labelValue, Collector.doubleToGoString((double)q)});
    }
}

