/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.system.metrics.dmnhandlers;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DecisionConstants;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.TypeHandler;

public class BooleanHandler
implements TypeHandler<Boolean> {
    private final Counter counter;
    private String dmnType;

    public BooleanHandler(String dmnType, CollectorRegistry registry) {
        this.dmnType = dmnType;
        this.counter = this.initializeCounter(dmnType, registry);
    }

    public BooleanHandler(String dmnType) {
        this(dmnType, null);
    }

    @Override
    public void record(String decision, String endpointName, Boolean sample) {
        ((Counter.Child)this.counter.labels(new String[]{decision, endpointName, sample.toString()})).inc();
    }

    @Override
    public String getDmnType() {
        return this.dmnType;
    }

    private Counter initializeCounter(String dmnType, CollectorRegistry registry) {
        Counter.Builder builder = (Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(dmnType + "_dmn_result")).help("Decision output.")).labelNames(DecisionConstants.DECISION_ENDPOINT_IDENTIFIER_LABELS);
        return registry == null ? (Counter)builder.register(CollectorRegistry.defaultRegistry) : (Counter)builder.register(registry);
    }
}

