/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.integration.AbstractQuantilesTest;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.DaysAndTimeDurationHandler;

public class DaysAndTimeDurationHandlerTest
extends AbstractQuantilesTest<DaysAndTimeDurationHandler> {
    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new DaysAndTimeDurationHandler("hello", this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void givenDurationMetricsWhenMetricsAreStoredThenTheQuantilesAreCorrect() {
        Integer expectedValue = 10000;
        Duration duration = Duration.ofMillis(expectedValue.intValue());
        Double[] quantiles = new Double[]{0.1, 0.25, 0.5, 0.75, 0.9, 0.99};
        ((DaysAndTimeDurationHandler)this.handler).record("decision", "hello", duration);
        for (Double key : quantiles) {
            Assertions.assertEquals((double)expectedValue.intValue(), (double)this.getQuantile("decision", "hello_dmn_result", "hello", key), (double)5.0);
        }
    }
}

