/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.system.metrics.SystemMetricsCollector;

public class SystemMetricsCollectorTest {
    private static final String handler = "hello";
    CollectorRegistry registry;

    @BeforeEach
    public void setUp() {
        this.registry = CollectorRegistry.defaultRegistry;
    }

    @Test
    public void givenAStatusCodeWhenRegisterStatusCodeRequestIsCalledThenTheStatusCodeIsExportedToPrometheus() {
        HashMap<String, Integer> mapCodeRepetition = new HashMap<String, Integer>();
        mapCodeRepetition.put("400", 100);
        mapCodeRepetition.put("404", 50);
        IntStream.range(0, (Integer)mapCodeRepetition.get("400")).forEach(x -> SystemMetricsCollector.registerStatusCodeRequest((String)handler, (String)"400"));
        IntStream.range(0, (Integer)mapCodeRepetition.get("404")).forEach(x -> SystemMetricsCollector.registerStatusCodeRequest((String)handler, (String)"404"));
        Assertions.assertEquals((Integer)((Integer)mapCodeRepetition.get("400")), (int)this.getLabelsValue("api_http_response_code", handler, "400").intValue());
        Assertions.assertEquals((Integer)((Integer)mapCodeRepetition.get("404")), (int)this.getLabelsValue("api_http_response_code", handler, "404").intValue());
    }

    @Test
    public void givenAnExceptionWhenRegisterExceptionIsCalledThenTheStatusCodeIsExportedToPrometheus() {
        HashMap<String, Integer> mapExceptionRepetition = new HashMap<String, Integer>();
        mapExceptionRepetition.put("NoSuchElement", 10);
        mapExceptionRepetition.put("Exception", 20);
        IntStream.range(0, (Integer)mapExceptionRepetition.get("NoSuchElement")).forEach(x -> SystemMetricsCollector.registerException((String)handler, (String)"NoSuchElement"));
        IntStream.range(0, (Integer)mapExceptionRepetition.get("Exception")).forEach(x -> SystemMetricsCollector.registerException((String)handler, (String)"Exception"));
        Assertions.assertEquals((Integer)((Integer)mapExceptionRepetition.get("NoSuchElement")), (int)this.getLabelsValue("api_http_stacktrace_exceptions", handler, "NoSuchElement").intValue());
        Assertions.assertEquals((Integer)((Integer)mapExceptionRepetition.get("Exception")), (int)this.getLabelsValue("api_http_stacktrace_exceptions", handler, "Exception").intValue());
    }

    @Test
    public void givenAnElapsedTimeSampleWhenRegisterElapsedTimeSampleMetricsThenTheStatusCodeIsExportedToPrometheus() {
        HashMap<Double, Double> expectedQuantiles = new HashMap<Double, Double>();
        expectedQuantiles.put(0.1, 999.0);
        expectedQuantiles.put(0.25, 2525.0);
        expectedQuantiles.put(0.5, 5042.0);
        expectedQuantiles.put(0.75, 7551.0);
        expectedQuantiles.put(0.9, 9062.0);
        expectedQuantiles.put(0.99, 10000.0);
        IntStream.range(1, 10001).forEach(x -> SystemMetricsCollector.registerElapsedTimeSampleMetrics((String)handler, (double)x));
        for (Double key : expectedQuantiles.keySet()) {
            Assertions.assertEquals((double)((Double)expectedQuantiles.get(key)), (double)this.getQuantile("api_execution_elapsed_nanosecond", handler, key), (double)5.0);
        }
    }

    private double getQuantile(String name, String labelValue, double q) {
        return this.registry.getSampleValue(name, new String[]{"endpoint", "quantile"}, new String[]{labelValue, Collector.doubleToGoString((double)q)});
    }

    private Double getLabelsValue(String name, String handler, String identifier) {
        return this.registry.getSampleValue(name, new String[]{"endpoint", "identifier"}, new String[]{handler, identifier});
    }
}

