/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import ch.obermuhlner.math.big.stream.BigDecimalStream;
import io.prometheus.client.CollectorRegistry;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.integration.AbstractQuantilesTest;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.BigDecimalHandler;

public class BigDecimalHandlerTest
extends AbstractQuantilesTest<BigDecimalHandler> {
    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new BigDecimalHandler("hello", this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void givenSomeSamplesWhenQuantilesAreCalculatedThenTheQuantilesAreCorrect() {
        HashMap<Double, Double> expectedQuantiles = new HashMap<Double, Double>();
        expectedQuantiles.put(0.1, 999.0);
        expectedQuantiles.put(0.25, 2525.0);
        expectedQuantiles.put(0.5, 5042.0);
        expectedQuantiles.put(0.75, 7551.0);
        expectedQuantiles.put(0.9, 9062.0);
        expectedQuantiles.put(0.99, 10000.0);
        BigDecimalStream.range((BigDecimal)BigDecimal.valueOf(1L), (BigDecimal)BigDecimal.valueOf(10001L), (BigDecimal)BigDecimal.ONE, (MathContext)MathContext.DECIMAL64).forEach(x -> ((BigDecimalHandler)this.handler).record("decision", "hello", x));
        for (Double key : expectedQuantiles.keySet()) {
            Assertions.assertEquals((double)((Double)expectedQuantiles.get(key)), (double)this.getQuantile("decision", "hello_dmn_result", "hello", key), (double)5.0);
        }
    }
}

