/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.integration;

import io.prometheus.client.CollectorRegistry;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.integration.AbstractQuantilesTest;
import org.kie.kogito.monitoring.system.metrics.dmnhandlers.LocalDateTimeHandler;

public class LocalDateTimeHandlerTest
extends AbstractQuantilesTest<LocalDateTimeHandler> {
    @BeforeEach
    public void setUp() {
        this.registry = new CollectorRegistry();
        this.handler = new LocalDateTimeHandler("hello", this.registry);
    }

    @AfterEach
    public void destroy() {
        this.registry.clear();
    }

    @Test
    public void givenLocalDateTimeMetricsWhenMetricsAreStoredThenTheQuantilesAreCorrect() {
        LocalDateTime now = LocalDateTime.now();
        Long expectedValue = now.toInstant(ZoneOffset.UTC).toEpochMilli();
        Double[] quantiles = new Double[]{0.1, 0.25, 0.5, 0.75, 0.9, 0.99};
        ((LocalDateTimeHandler)this.handler).record("decision", "hello", now);
        for (Double key : quantiles) {
            Assertions.assertEquals((double)expectedValue.longValue(), (double)this.getQuantile("decision", "hello_dmn_result", "hello", key), (double)5.0);
        }
    }
}

