/*
 * Decompiled with CFR 0.152.
 */
package org.kie.addons.monitoring.rule;

import io.prometheus.client.Histogram;
import java.util.stream.IntStream;

public class PrometheusMetrics {
    private static final long NANOSECONDS_PER_MICROSECOND = 1000000L;
    private static final double[] RULE_TIME_BUCKETS = PrometheusMetrics.rangeMicro(1, 10);
    private static final Histogram droolsEvaluationTimeHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("drl_match_fired_nanosecond")).help("Drools Firing Time")).labelNames(new String[]{"identifier", "rule_name"})).buckets(RULE_TIME_BUCKETS).register();

    private static long toMicro(long second) {
        return second * 1000000L;
    }

    private static double[] rangeMicro(int start, int end) {
        return IntStream.range(start, end).mapToDouble(l -> PrometheusMetrics.toMicro(l)).toArray();
    }

    protected static double millisToSeconds(long millis) {
        return (double)millis / 1000.0;
    }

    public static Histogram getDroolsEvaluationTimeHistogram() {
        return droolsEvaluationTimeHistogram;
    }
}

