/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.system.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Summary;

public class SystemMetricsCollector {
    private static final String STATUS_CODE_NAME = "api_http_response_code";
    private static final String STATUS_CODE_HELP = "Request status code.";
    private static final String[] ENDPOINT_LABEL = new String[]{"endpoint"};
    private static final String[] ENDPOINT_INDENTIFIER_LABELS = new String[]{"endpoint", "identifier"};
    private static final String ELAPSED_TIME_NAME = "api_execution_elapsed_nanosecond";
    private static final String ELAPSED_TIME_HELP = "Endpoint execution elapsed nanoseconds, 3 minutes time window.";
    private static final String EXCEPTIONS_NAME = "api_http_stacktrace_exceptions";
    private static final String EXCEPTIONS_HELP = "System exceptions details.";
    private static final Counter REQUEST_STATUS_CODE_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("api_http_response_code")).help("Request status code.")).labelNames(ENDPOINT_INDENTIFIER_LABELS)).register();
    private static final Counter EXCEPTIONS_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("api_http_stacktrace_exceptions")).help("System exceptions details.")).labelNames(ENDPOINT_INDENTIFIER_LABELS)).register();
    private static final Summary ELAPSED_TIME_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.1, 0.01).quantile(0.25, 0.05).quantile(0.5, 0.05).quantile(0.75, 0.05).quantile(0.9, 0.05).quantile(0.99, 0.01).maxAgeSeconds(180L).name("api_execution_elapsed_nanosecond")).help("Endpoint execution elapsed nanoseconds, 3 minutes time window.")).labelNames(ENDPOINT_LABEL)).register();

    private SystemMetricsCollector() {
    }

    public static void registerStatusCodeRequest(String endpoint, String statusCode) {
        ((Counter.Child)REQUEST_STATUS_CODE_COUNTER.labels(new String[]{endpoint, statusCode})).inc();
    }

    public static void registerElapsedTimeSampleMetrics(String endpoint, double elapsedTime) {
        ((Summary.Child)ELAPSED_TIME_SUMMARY.labels(new String[]{endpoint})).observe(elapsedTime);
    }

    public static void registerException(String endpoint, String stackTrace) {
        ((Counter.Child)EXCEPTIONS_COUNTER.labels(new String[]{endpoint, stackTrace})).inc();
    }
}

