/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectCreatedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectRemovedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectUpdatedListener;
import org.kie.kogito.persistence.infinispan.query.InfinispanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl<K, V>
implements Storage<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageImpl.class);
    private RemoteCache<K, V> delegate;
    private String rootType;

    public StorageImpl(RemoteCache<K, V> delegate, String rootType) {
        this.delegate = delegate;
        this.rootType = rootType;
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public void clear() {
        this.delegate.clear();
    }

    public V remove(Object key) {
        return (V)this.delegate.remove(key);
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public V put(K key, V value) {
        return (V)this.delegate.put(key, value);
    }

    public void addObjectCreatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object created listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectCreatedListener<K, V>(this.delegate, consumer));
    }

    public void addObjectUpdatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object updated listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectUpdatedListener<K, V>(this.delegate, consumer));
    }

    public void addObjectRemovedListener(Consumer<K> consumer) {
        LOGGER.debug("Adding new object removed listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectRemovedListener<K>(consumer));
    }

    public RemoteCache<K, V> getDelegate() {
        return this.delegate;
    }

    public String getRootType() {
        return this.rootType;
    }

    public Query<V> query() {
        return new InfinispanQuery<V>(this.delegate, this.rootType);
    }
}

