/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.query;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanQuery<T>
implements Query<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanQuery.class);
    private static final String AND = " and ";
    private static final String OR = " or ";
    private static final String ATTRIBUTE_VALUE = "o.%s = %s";
    private QueryFactory qf;
    private Integer limit;
    private Integer offset;
    private List<AttributeFilter<?>> filters;
    private List<AttributeSort> sortBy;
    private String rootType;

    public InfinispanQuery(RemoteCache<?, T> delegate, String rootType) {
        this(Search.getQueryFactory(delegate), rootType);
    }

    protected InfinispanQuery(QueryFactory qf, String rootType) {
        this.qf = qf;
        this.rootType = rootType;
    }

    private static Function<Object, Object> getValueForQueryString() {
        return value -> value instanceof String ? "'" + value + "'" : value.toString();
    }

    public Query<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query<T> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    public Query<T> sort(List<AttributeSort> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<T> execute() {
        StringBuilder queryString = new StringBuilder("from " + this.rootType + " o");
        if (this.filters != null && !this.filters.isEmpty()) {
            queryString.append(" where ");
            queryString.append(this.filters.stream().map(this.filterStringFunction()).collect(Collectors.joining(AND)));
        }
        if (this.sortBy != null && !this.sortBy.isEmpty()) {
            queryString.append(" order by ");
            queryString.append(this.sortBy.stream().map(f -> "o." + f.getAttribute() + " " + f.getSort().name()).collect(Collectors.joining(", ")));
        }
        LOGGER.debug("Executing Infinispan query: {}", (Object)queryString);
        org.infinispan.query.dsl.Query query = this.qf.create(queryString.toString());
        if (this.limit != null) {
            query.maxResults(this.limit.intValue());
        }
        if (this.offset != null) {
            query.startOffset((long)this.offset.intValue());
        }
        return query.list();
    }

    private Function<AttributeFilter<?>, String> filterStringFunction() {
        return filter -> {
            switch (filter.getCondition()) {
                case CONTAINS: {
                    return String.format(ATTRIBUTE_VALUE, filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case CONTAINS_ALL: {
                    return ((List)filter.getValue()).stream().map(o -> String.format(ATTRIBUTE_VALUE, filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(o))).collect(Collectors.joining(AND));
                }
                case CONTAINS_ANY: {
                    return ((List)filter.getValue()).stream().map(o -> String.format(ATTRIBUTE_VALUE, filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(o))).collect(Collectors.joining(OR));
                }
                case LIKE: {
                    return String.format("o.%s like %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue())).replaceAll("\\*", "%");
                }
                case EQUAL: {
                    return String.format(ATTRIBUTE_VALUE, filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case IN: {
                    return String.format("o.%s in (%s)", filter.getAttribute(), ((List)filter.getValue()).stream().map(InfinispanQuery.getValueForQueryString()).collect(Collectors.joining(", ")));
                }
                case IS_NULL: {
                    return String.format("o.%s is null", filter.getAttribute());
                }
                case NOT_NULL: {
                    return String.format("o.%s is not null", filter.getAttribute());
                }
                case BETWEEN: {
                    List value = (List)filter.getValue();
                    return String.format("o.%s between %s and %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(value.get(0)), InfinispanQuery.getValueForQueryString().apply(value.get(1)));
                }
                case GT: {
                    return String.format("o.%s > %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case GTE: {
                    return String.format("o.%s >= %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case LT: {
                    return String.format("o.%s < %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case LTE: {
                    return String.format("o.%s <= %s", filter.getAttribute(), InfinispanQuery.getValueForQueryString().apply(filter.getValue()));
                }
                case OR: {
                    return this.getRecursiveString((AttributeFilter<?>)filter, OR);
                }
                case AND: {
                    return this.getRecursiveString((AttributeFilter<?>)filter, AND);
                }
            }
            return null;
        };
    }

    private String getRecursiveString(AttributeFilter<?> filter, String joining) {
        return ((List)filter.getValue()).stream().map(this.filterStringFunction()).collect(Collectors.joining(joining));
    }
}

