/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectCreatedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectRemovedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectUpdatedListener;
import org.kie.kogito.persistence.infinispan.query.InfinispanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanStorage<K, V>
implements Storage<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanStorage.class);
    private RemoteCache<K, V> delegate;
    private String rootType;

    public InfinispanStorage(RemoteCache<K, V> delegate, String rootType) {
        this.delegate = delegate;
        this.rootType = rootType;
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public void clear() {
        this.delegate.clear();
    }

    public V remove(Object key) {
        return (V)this.delegate.remove(key);
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    public Map<K, V> entries() {
        return new HashMap<K, V>(this.delegate);
    }

    public V put(K key, V value) {
        return (V)this.delegate.put(key, value);
    }

    public Multi<V> objectCreatedListener() {
        LOGGER.debug("Adding new object created listener into Cache: {}", (Object)this.delegate.getName());
        UnicastProcessor processor = UnicastProcessor.create();
        CacheObjectCreatedListener<K, Object> listener = new CacheObjectCreatedListener<K, Object>(this.delegate, v -> processor.onNext(v));
        return processor.onSubscription().invoke(s -> this.delegate.addClientListener((Object)listener)).onTermination().invoke(() -> this.delegate.removeClientListener((Object)listener));
    }

    public Multi<V> objectUpdatedListener() {
        LOGGER.debug("Adding new object updated listener into Cache: {}", (Object)this.delegate.getName());
        UnicastProcessor processor = UnicastProcessor.create();
        CacheObjectUpdatedListener<K, Object> listener = new CacheObjectUpdatedListener<K, Object>(this.delegate, v -> processor.onNext(v));
        return processor.onSubscription().invoke(s -> this.delegate.addClientListener((Object)listener)).onTermination().invoke(() -> this.delegate.removeClientListener((Object)listener));
    }

    public Multi<K> objectRemovedListener() {
        LOGGER.debug("Adding new object removed listener into Cache: {}", (Object)this.delegate.getName());
        UnicastProcessor processor = UnicastProcessor.create();
        CacheObjectRemovedListener<Object> listener = new CacheObjectRemovedListener<Object>(v -> processor.onNext(v));
        return processor.onSubscription().invoke(s -> this.delegate.addClientListener((Object)listener)).onTermination().invoke(() -> this.delegate.removeClientListener((Object)listener));
    }

    public RemoteCache<K, V> getDelegate() {
        return this.delegate;
    }

    public String getRootType() {
        return this.rootType;
    }

    public Query<V> query() {
        return new InfinispanQuery<V>(this.delegate, this.rootType);
    }
}

