/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JsonDataFormatMarshaller
extends AbstractMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDataFormatMarshaller.class);
    @Inject
    ObjectMapper mapper;

    protected ByteBuffer objectToBuffer(Object object, int estimatedSize) {
        String json = object.toString();
        LOGGER.debug("Serializing JSON: \n{}", (Object)json);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        return ByteBufferImpl.create((byte[])bytes, (int)0, (int)bytes.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return this.mapper.readTree(buf);
    }

    public boolean isMarshallable(Object o) {
        return o instanceof ObjectNode;
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

