/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.client;

import com.mongodb.client.MongoCollection;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class MongoClientManagerIT {
    @Inject
    MongoClientManager mongoClientManager;

    MongoClientManagerIT() {
    }

    @Test
    void testGetCollection() {
        MongoCollection mongoCollection = this.mongoClientManager.getCollection("test");
        Assertions.assertEquals((Object)this.mongoClientManager.database, (Object)mongoCollection.getNamespace().getDatabaseName());
        Assertions.assertEquals((Object)"test", (Object)mongoCollection.getNamespace().getCollectionName());
    }

    @Test
    void testGetCollection_withDocumentClass() {
        MongoCollection mongoCollection = this.mongoClientManager.getCollection("test", TestClass.class);
        Assertions.assertEquals((Object)this.mongoClientManager.database, (Object)mongoCollection.getNamespace().getDatabaseName());
        Assertions.assertEquals((Object)"test", (Object)mongoCollection.getNamespace().getCollectionName());
        Assertions.assertTrue((boolean)mongoCollection.getDocumentClass().isAssignableFrom(TestClass.class));
    }

    @Test
    void testGetReactiveCollection() {
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection = this.mongoClientManager.getReactiveCollection("test");
        Assertions.assertEquals((Object)this.mongoClientManager.database, (Object)mongoCollection.getNamespace().getDatabaseName());
        Assertions.assertEquals((Object)"test", (Object)mongoCollection.getNamespace().getCollectionName());
    }

    @Test
    void testGetReactiveCollection_withDocumentClass() {
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection = this.mongoClientManager.getReactiveCollection("test", TestClass.class);
        Assertions.assertEquals((Object)this.mongoClientManager.database, (Object)mongoCollection.getNamespace().getDatabaseName());
        Assertions.assertEquals((Object)"test", (Object)mongoCollection.getNamespace().getCollectionName());
        Assertions.assertTrue((boolean)mongoCollection.getDocumentClass().isAssignableFrom(TestClass.class));
    }

    private static class TestClass {
        private TestClass() {
        }
    }
}

